/*
 * Decompiled with CFR 0.152.
 */
package hudson.scm;

import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Proc;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.ModelObject;
import hudson.model.Run;
import hudson.model.TaskAction;
import hudson.model.TaskListener;
import hudson.model.TaskThread;
import hudson.remoting.Future;
import hudson.remoting.RemoteOutputStream;
import hudson.remoting.VirtualChannel;
import hudson.scm.AbstractScmTagAction;
import hudson.scm.CVSChangeLogParser;
import hudson.scm.CVSRepositoryBrowser;
import hudson.scm.ChangeLogParser;
import hudson.scm.RepositoryBrowsers;
import hudson.scm.SCM;
import hudson.scm.SCMDescriptor;
import hudson.scm.cvs.Messages;
import hudson.security.Permission;
import hudson.util.ArgumentListBuilder;
import hudson.util.AtomicFileWriter;
import hudson.util.ForkOutputStream;
import hudson.util.FormValidation;
import hudson.util.IOException2;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Serializable;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeSet;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.servlet.ServletException;
import net.sf.json.JSONObject;
import org.apache.commons.io.FileUtils;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Expand;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipOutputStream;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;
import org.kohsuke.stapler.framework.io.ByteBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CVSSCM
extends SCM
implements Serializable {
    private String cvsroot;
    private String module;
    private String branch;
    private String cvsRsh;
    private boolean canUseUpdate;
    private boolean flatten;
    private CVSRepositoryBrowser repositoryBrowser;
    private boolean isTag;
    private String excludedRegions;
    private static final Pattern UPDATE_LINE = Pattern.compile("[UPARMC] (.+)");
    private static final Pattern REMOVAL_LINE = Pattern.compile("cvs (server|update): `?(.+?)'? is no longer in the repository");
    private static final Pattern PSERVER_CVSROOT_WITH_PASSWORD = Pattern.compile("(:pserver:[^@:]+):[^@:]+(@.+)");
    public static boolean debug = Boolean.getBoolean(CVSSCM.class.getName() + ".debug");
    public static boolean noQuiet = Boolean.getBoolean(CVSSCM.class.getName() + ".noQuiet");
    private static final long serialVersionUID = 1L;
    public static boolean skipChangeLog = Boolean.getBoolean(CVSSCM.class.getName() + ".skipChangeLog");
    private static final Logger LOGGER = Logger.getLogger(CVSSCM.class.getName());

    @DataBoundConstructor
    public CVSSCM(String cvsRoot, String allModules, String branch, String cvsRsh, boolean canUseUpdate, boolean legacy, boolean isTag, String excludedRegions) {
        if (Util.fixNull((String)branch).equals("HEAD")) {
            branch = null;
        }
        this.cvsroot = Util.fixNull((String)cvsRoot).trim();
        this.module = allModules.trim();
        this.branch = this.nullify(branch);
        this.cvsRsh = this.nullify(cvsRsh);
        this.canUseUpdate = canUseUpdate;
        this.flatten = !legacy && this.getAllModulesNormalized().length == 1;
        this.isTag = isTag;
        this.excludedRegions = excludedRegions;
    }

    public CVSRepositoryBrowser getBrowser() {
        return this.repositoryBrowser;
    }

    private String compression() {
        if (this.getDescriptor().isNoCompression()) {
            return null;
        }
        boolean local = this.cvsroot.startsWith("/") || this.cvsroot.startsWith(":local:") || this.cvsroot.startsWith(":fork:");
        return local ? "-z0" : "-z3";
    }

    @Exported
    public String getCvsRoot() {
        return this.cvsroot;
    }

    @Exported
    public boolean isTag() {
        return this.isTag;
    }

    public FilePath getModuleRoot(FilePath workspace) {
        if (this.flatten) {
            return workspace;
        }
        return workspace.child(this.getAllModulesNormalized()[0]);
    }

    public FilePath[] getModuleRoots(FilePath workspace) {
        if (!this.flatten) {
            String[] moduleLocations = this.getAllModulesNormalized();
            FilePath[] moduleRoots = new FilePath[moduleLocations.length];
            for (int i = 0; i < moduleLocations.length; ++i) {
                moduleRoots[i] = workspace.child(moduleLocations[i]);
            }
            return moduleRoots;
        }
        return new FilePath[]{this.getModuleRoot(workspace)};
    }

    public ChangeLogParser createChangeLogParser() {
        return new CVSChangeLogParser();
    }

    @Exported
    public String getAllModules() {
        return this.module;
    }

    @Exported
    public String getExcludedRegions() {
        return this.excludedRegions;
    }

    public String[] getExcludedRegionsNormalized() {
        return this.excludedRegions == null ? null : this.excludedRegions.split("[\\r\\n]+");
    }

    private Pattern[] getExcludedRegionsPatterns() {
        String[] excludedRegions = this.getExcludedRegionsNormalized();
        if (excludedRegions != null) {
            Pattern[] patterns = new Pattern[excludedRegions.length];
            int i = 0;
            for (String excludedRegion : excludedRegions) {
                patterns[i++] = Pattern.compile(excludedRegion);
            }
            return patterns;
        }
        return null;
    }

    public String[] getAllModulesNormalized() {
        String[] r = this.module.split("(?<!\\\\)[ \\r\\n]+");
        for (int i = 0; i < r.length; ++i) {
            r[i] = r[i].replaceAll("\\\\ ", " ");
        }
        return r;
    }

    @Exported
    public String getBranch() {
        return this.branch;
    }

    @Exported
    public String getCvsRsh() {
        return this.cvsRsh;
    }

    @Exported
    public boolean getCanUseUpdate() {
        return this.canUseUpdate;
    }

    @Exported
    public boolean isFlatten() {
        return this.flatten;
    }

    public boolean isLegacy() {
        return !this.flatten;
    }

    public boolean pollChanges(AbstractProject project, Launcher launcher, FilePath dir, TaskListener listener) throws IOException, InterruptedException {
        String why = this.isUpdatable(dir);
        if (why != null) {
            listener.getLogger().println(Messages.CVSSCM_WorkspaceInconsistent(why));
            return true;
        }
        List<String> changedFiles = this.update(true, launcher, dir, listener, new Date());
        if (changedFiles != null && !changedFiles.isEmpty()) {
            Pattern[] patterns = this.getExcludedRegionsPatterns();
            if (patterns != null) {
                boolean areThereChanges = false;
                for (String changedFile : changedFiles) {
                    boolean patternMatched = false;
                    for (Pattern pattern : patterns) {
                        if (!pattern.matcher(changedFile).matches()) continue;
                        patternMatched = true;
                        break;
                    }
                    if (patternMatched) continue;
                    areThereChanges = true;
                    break;
                }
                return areThereChanges;
            }
            return true;
        }
        return false;
    }

    private void configureDate(ArgumentListBuilder cmd, Date date) {
        if (this.isTag) {
            return;
        }
        DateFormat df = DateFormat.getDateTimeInstance(0, 0, Locale.US);
        df.setTimeZone(TimeZone.getTimeZone("UTC"));
        cmd.add(new String[]{"-D", df.format(date)});
    }

    public boolean checkout(AbstractBuild build, Launcher launcher, FilePath ws, BuildListener listener, File changelogFile) throws IOException, InterruptedException {
        List<String> changedFiles = null;
        if (this.canUseUpdate && this.isUpdatable(ws) == null ? (changedFiles = this.update(false, launcher, ws, (TaskListener)listener, build.getTimestamp().getTime())) == null : !this.checkout(launcher, ws, (TaskListener)listener, build.getTimestamp().getTime())) {
            return false;
        }
        File archiveFile = CVSSCM.getArchiveFile(build);
        RemoteOutputStream os = new RemoteOutputStream((OutputStream)new FileOutputStream(archiveFile));
        ws.act((FilePath.FileCallable)new FilePath.FileCallable<Void>((OutputStream)os){
            final /* synthetic */ OutputStream val$os;
            {
                this.val$os = outputStream;
            }

            public Void invoke(File ws, VirtualChannel channel) throws IOException {
                ZipOutputStream zos = new ZipOutputStream((OutputStream)new BufferedOutputStream(this.val$os));
                String[] modules = CVSSCM.this.getAllModulesNormalized();
                if (CVSSCM.this.flatten) {
                    assert (modules.length == 1);
                    CVSSCM.this.archive(ws, modules[0], zos, true);
                } else {
                    for (String m : modules) {
                        File mf = new File(ws, m);
                        if (!mf.exists()) continue;
                        if (!mf.isDirectory()) {
                            int idx = m.lastIndexOf(47);
                            if (idx == -1) {
                                throw new Error("Kohsuke probe: m=" + m);
                            }
                            m = m.substring(0, idx);
                            mf = mf.getParentFile();
                        }
                        CVSSCM.this.archive(mf, m, zos, true);
                    }
                }
                zos.close();
                return null;
            }
        });
        build.getActions().add(new TagAction(build));
        return this.calcChangeLog(build, ws, changedFiles, changelogFile, listener);
    }

    public boolean checkout(Launcher launcher, FilePath dir, TaskListener listener) throws IOException, InterruptedException {
        Date now = new Date();
        if (this.canUseUpdate && this.isUpdatable(dir) == null) {
            return this.update(false, launcher, dir, listener, now) != null;
        }
        return this.checkout(launcher, dir, listener, now);
    }

    private boolean checkout(Launcher launcher, FilePath dir, TaskListener listener, Date dt) throws IOException, InterruptedException {
        dir.deleteContents();
        ArgumentListBuilder cmd = new ArgumentListBuilder();
        cmd.add(new String[]{this.getDescriptor().getCvsExeOrDefault(), noQuiet ? null : (debug ? "-t" : "-Q"), this.compression(), "-d", this.cvsroot, "co", "-P"});
        if (this.branch != null) {
            cmd.add(new String[]{"-r", this.branch});
        }
        if (this.flatten) {
            cmd.add(new String[]{"-d", dir.getName()});
        }
        this.configureDate(cmd, dt);
        cmd.add(this.getAllModulesNormalized());
        if (!this.run(launcher, cmd, listener, this.flatten ? dir.getParent() : dir)) {
            return false;
        }
        if (this.flatten) {
            dir.act((FilePath.FileCallable)new StickyDateCleanUpTask());
        } else {
            for (String module : this.getAllModulesNormalized()) {
                dir.child(module).act((FilePath.FileCallable)new StickyDateCleanUpTask());
            }
        }
        return true;
    }

    private static File getArchiveFile(AbstractBuild build) {
        return new File(build.getRootDir(), "workspace.zip");
    }

    private void archive(File dir, String relPath, ZipOutputStream zos, boolean isRoot) throws IOException {
        HashSet<String> knownFiles = new HashSet<String>();
        this.parseCVSEntries(new File(dir, "CVS/Entries"), knownFiles);
        this.parseCVSEntries(new File(dir, "CVS/Entries.Log"), knownFiles);
        this.parseCVSEntries(new File(dir, "CVS/Entries.Extra"), knownFiles);
        boolean hasCVSdirs = !knownFiles.isEmpty();
        knownFiles.add("CVS");
        File[] files = dir.listFiles();
        if (files == null) {
            if (isRoot) {
                throw new IOException("No such directory exists. Did you specify the correct branch? Perhaps you specified a tag: " + dir);
            }
            throw new IOException("No such directory exists. Looks like someone is modifying the workspace concurrently: " + dir);
        }
        for (File f : files) {
            String name = relPath + '/' + f.getName();
            if (f.isDirectory()) {
                if (hasCVSdirs && !knownFiles.contains(f.getName())) continue;
                this.archive(f, name, zos, false);
                continue;
            }
            if (!dir.getName().equals("CVS")) continue;
            zos.putNextEntry(new ZipEntry(name));
            FileInputStream fis = new FileInputStream(f);
            Util.copyStream((InputStream)fis, (OutputStream)zos);
            fis.close();
            zos.closeEntry();
        }
    }

    private void parseCVSEntries(File entries, Set<String> knownFiles) throws IOException {
        String line;
        if (!entries.exists()) {
            return;
        }
        BufferedReader in = new BufferedReader(new InputStreamReader(new FileInputStream(entries)));
        while ((line = in.readLine()) != null) {
            String[] tokens = line.split("/+");
            if (tokens == null || tokens.length < 2) continue;
            knownFiles.add(tokens[1]);
        }
        in.close();
    }

    private List<String> update(boolean dryRun, Launcher launcher, FilePath workspace, TaskListener listener, Date date) throws IOException, InterruptedException {
        ArrayList<String> changedFileNames = new ArrayList<String>();
        ArgumentListBuilder cmd = new ArgumentListBuilder();
        cmd.add(new String[]{this.getDescriptor().getCvsExeOrDefault(), debug ? "-t" : "-q", this.compression()});
        if (dryRun) {
            cmd.add("-n");
        }
        cmd.add(new String[]{"update", "-PdC"});
        if (this.branch != null) {
            cmd.add(new String[]{"-r", this.branch});
        }
        this.configureDate(cmd, date);
        if (this.flatten) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            if (!this.run(launcher, cmd, listener, workspace, (OutputStream)new ForkOutputStream((OutputStream)baos, (OutputStream)listener.getLogger()))) {
                return null;
            }
            Future task = workspace.actAsync((FilePath.FileCallable)new StickyDateCleanUpTask());
            this.parseUpdateOutput("", baos, changedFileNames);
            this.join((Future<Void>)task);
        } else {
            final TreeSet<String> moduleNames = new TreeSet<String>(Arrays.asList(this.getAllModulesNormalized()));
            moduleNames.addAll((Collection)workspace.act((FilePath.FileCallable)new FilePath.FileCallable<Set<String>>(){

                public Set<String> invoke(File ws, VirtualChannel channel) throws IOException {
                    File[] subdirs = ws.listFiles();
                    if (subdirs != null) {
                        block0: for (File s : subdirs) {
                            if (!new File(s, "CVS").isDirectory()) continue;
                            String top = s.getName();
                            for (String mod : moduleNames) {
                                if (!mod.startsWith(top + "/")) continue;
                                continue block0;
                            }
                            moduleNames.add(top);
                        }
                    }
                    return moduleNames;
                }
            }));
            for (String moduleName : moduleNames) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                FilePath modulePath = new FilePath(workspace, moduleName);
                ArgumentListBuilder actualCmd = cmd;
                String baseName = moduleName;
                if (!modulePath.isDirectory()) {
                    actualCmd = cmd.clone();
                    actualCmd.add(modulePath.getName());
                    modulePath = modulePath.getParent();
                    int slash = baseName.lastIndexOf(47);
                    if (slash > 0) {
                        baseName = baseName.substring(0, slash);
                    }
                }
                if (!this.run(launcher, actualCmd, listener, modulePath, (OutputStream)new ForkOutputStream((OutputStream)baos, (OutputStream)listener.getLogger()))) {
                    return null;
                }
                Future task = modulePath.actAsync((FilePath.FileCallable)new StickyDateCleanUpTask());
                this.parseUpdateOutput(baseName + '/', baos, changedFileNames);
                this.join((Future<Void>)task);
            }
        }
        return changedFileNames;
    }

    private void join(Future<Void> task) throws InterruptedException, IOException {
        try {
            task.get();
        }
        catch (ExecutionException e) {
            throw new IOException2((Throwable)e);
        }
    }

    private void parseUpdateOutput(String baseName, ByteArrayOutputStream output, List<String> result) throws IOException {
        String line;
        BufferedReader in = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(output.toByteArray())));
        while ((line = in.readLine()) != null) {
            Matcher matcher = UPDATE_LINE.matcher(line);
            if (matcher.matches()) {
                result.add(baseName + matcher.group(1));
                continue;
            }
            matcher = REMOVAL_LINE.matcher(line);
            if (!matcher.matches()) continue;
            result.add(baseName + matcher.group(2));
        }
    }

    private String isUpdatable(FilePath dir) throws IOException, InterruptedException {
        return (String)dir.act((FilePath.FileCallable)new FilePath.FileCallable<String>(){

            public String invoke(File dir, VirtualChannel channel) throws IOException {
                if (CVSSCM.this.flatten) {
                    return this.isUpdatableModule(dir);
                }
                for (String m : CVSSCM.this.getAllModulesNormalized()) {
                    File module = new File(dir, m);
                    String reason = this.isUpdatableModule(module);
                    if (reason == null) continue;
                    return reason;
                }
                return null;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            private String isUpdatableModule(File module) {
                try {
                    File cvs;
                    if (!module.isDirectory()) {
                        module = module.getParentFile();
                    }
                    if (!(cvs = new File(module, "CVS")).exists()) {
                        return "No CVS dir in " + module;
                    }
                    File cvsRootFile = new File(cvs, "Root");
                    if (!CVSSCM.this.checkContents(cvsRootFile, CVSSCM.this.cvsroot)) {
                        return cvs + "/Root content mismatch: expected " + CVSSCM.this.cvsroot + " but found " + FileUtils.readFileToString((File)cvsRootFile);
                    }
                    if (CVSSCM.this.branch != null) {
                        if (CVSSCM.this.checkContents(new File(cvs, "Tag"), (CVSSCM.this.isTag() ? (char)'N' : 'T') + CVSSCM.this.branch)) return null;
                        return cvs + " branch mismatch";
                    }
                    File tag = new File(cvs, "Tag");
                    if (!tag.exists()) return null;
                    BufferedReader r = new BufferedReader(new FileReader(tag));
                    try {
                        String s = r.readLine();
                        if (s != null && s.startsWith("D")) {
                            String string = null;
                            return string;
                        }
                        String string = "Workspace is on branch " + s;
                        return string;
                    }
                    finally {
                        r.close();
                    }
                }
                catch (IOException e) {
                    return e.getMessage();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean checkContents(File file, String contents) {
        try {
            BufferedReader r = new BufferedReader(new FileReader(file));
            try {
                String s = r.readLine();
                if (s == null) {
                    boolean bl = false;
                    return bl;
                }
                boolean bl = this.massageForCheckContents(s).equals(this.massageForCheckContents(contents));
                return bl;
            }
            finally {
                r.close();
            }
        }
        catch (IOException e) {
            return false;
        }
    }

    private String massageForCheckContents(String s) {
        Matcher m = PSERVER_CVSROOT_WITH_PASSWORD.matcher(s = s.trim());
        if (m.matches()) {
            s = m.group(1) + m.group(2);
        }
        return s;
    }

    /*
     * Exception decompiling
     */
    private boolean calcChangeLog(AbstractBuild build, FilePath ws, List<String> changedFiles, File changelogFile, BuildListener listener) throws InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    public void buildEnvVars(AbstractBuild build, Map<String, String> env) {
        String cvspass;
        if (this.cvsRsh != null) {
            env.put("CVS_RSH", this.cvsRsh);
        }
        if (this.branch != null) {
            env.put("CVS_BRANCH", this.branch);
        }
        if ((cvspass = this.getDescriptor().getCvspassFile()).length() != 0) {
            env.put("CVS_PASSFILE", cvspass);
        }
    }

    protected final boolean run(Launcher launcher, ArgumentListBuilder cmd, TaskListener listener, FilePath dir, OutputStream out) throws IOException, InterruptedException {
        Map<String, String> env = this.createEnvVarMap(true);
        int r = launcher.launch().cmds(cmd).envs(env).stdout(out).pwd(dir).join();
        if (r != 0) {
            listener.fatalError(this.getDescriptor().getDisplayName() + " failed. exit code=" + r);
        }
        return r == 0;
    }

    protected final boolean run(Launcher launcher, ArgumentListBuilder cmd, TaskListener listener, FilePath dir) throws IOException, InterruptedException {
        return this.run(launcher, cmd, listener, dir, listener.getLogger());
    }

    protected final Map<String, String> createEnvVarMap(boolean overrideOnly) {
        HashMap<String, String> env = new HashMap<String, String>();
        if (!overrideOnly) {
            env.putAll(EnvVars.masterEnvVars);
        }
        this.buildEnvVars(null, env);
        return env;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class TagWorkerThread
    extends TaskThread {
        private final Map<AbstractBuild, String> tagSet;

        public TagWorkerThread(TagAction owner, Map<AbstractBuild, String> tagSet) {
            super((TaskAction)owner, TaskThread.ListenerAndText.forMemory());
            this.tagSet = tagSet;
        }

        public synchronized void start() {
            for (Map.Entry<AbstractBuild, String> e : this.tagSet.entrySet()) {
                TagAction ta = (TagAction)e.getKey().getAction(TagAction.class);
                if (ta == null) continue;
                this.associateWith((TaskAction)ta);
            }
            super.start();
        }

        protected void perform(TaskListener listener) {
            for (Map.Entry<AbstractBuild, String> e : this.tagSet.entrySet()) {
                TagAction ta = (TagAction)e.getKey().getAction(TagAction.class);
                if (ta == null) {
                    listener.error(e.getKey() + " doesn't have CVS tag associated with it. Skipping");
                    continue;
                }
                listener.getLogger().println(Messages.CVSSCM_TagginXasY(e.getKey(), e.getValue()));
                try {
                    e.getKey().keepLog();
                }
                catch (IOException x) {
                    x.printStackTrace(listener.error(Messages.CVSSCM_FailedToMarkForKeep(e.getKey())));
                }
                ta.perform(e.getValue(), listener);
                listener.getLogger().println();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class TagActionDescriptor
    extends Descriptor<TagAction> {
        public TagActionDescriptor() {
            super(TagAction.class);
        }

        public String getDisplayName() {
            return "";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @ExportedBean
    public final class TagAction
    extends AbstractScmTagAction
    implements Describable<TagAction> {
        private volatile String tagName;

        public TagAction(AbstractBuild build) {
            super(build);
        }

        public String getIconFileName() {
            if (this.tagName == null && !this.build.getParent().getACL().hasPermission(SCM.TAG)) {
                return null;
            }
            return "save.gif";
        }

        public String getDisplayName() {
            if (this.tagName == null) {
                return Messages.CVSSCM_TagThisBuild();
            }
            if (this.tagName.indexOf(32) >= 0) {
                return Messages.CVSSCM_DisplayName2();
            }
            return Messages.CVSSCM_DisplayName1();
        }

        @Exported
        public String[] getTagNames() {
            if (this.tagName == null) {
                return new String[0];
            }
            return this.tagName.split(" ");
        }

        public synchronized FormValidation doCheckTag(@QueryParameter String value) {
            String tag = Util.fixNull((String)value).trim();
            if (tag.length() == 0) {
                return FormValidation.ok();
            }
            return FormValidation.error((String)this.isInvalidTag(tag));
        }

        public Permission getPermission() {
            return SCM.TAG;
        }

        public String getTooltip() {
            if (this.tagName != null) {
                return "Tag: " + this.tagName;
            }
            return null;
        }

        public boolean isTagged() {
            return this.tagName != null;
        }

        public synchronized void doSubmit(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
            this.build.checkPermission(this.getPermission());
            HashMap<AbstractBuild, String> tagSet = new HashMap<AbstractBuild, String>();
            String name = Util.fixNull((String)req.getParameter("name")).trim();
            String reason = this.isInvalidTag(name);
            if (reason != null) {
                this.sendError(reason, req, rsp);
                return;
            }
            tagSet.put(this.build, name);
            if (req.getParameter("upstream") != null) {
                Enumeration e = req.getParameterNames();
                Map upstreams = this.build.getUpstreamBuilds();
                while (e.hasMoreElements()) {
                    String upName = (String)e.nextElement();
                    if (!upName.startsWith("upstream.")) continue;
                    String tag = Util.fixNull((String)req.getParameter(upName)).trim();
                    reason = this.isInvalidTag(tag);
                    if (reason != null) {
                        this.sendError(Messages.CVSSCM_NoValidTagNameGivenFor(upName, reason), req, rsp);
                        return;
                    }
                    upName = upName.substring(9);
                    AbstractProject p = (AbstractProject)Hudson.getInstance().getItemByFullName(upName, AbstractProject.class);
                    if (p == null) {
                        this.sendError(Messages.CVSSCM_NoSuchJobExists(upName), req, rsp);
                        return;
                    }
                    Run build = p.getBuildByNumber(((Integer)upstreams.get(p)).intValue());
                    tagSet.put((AbstractBuild)build, tag);
                }
            }
            new TagWorkerThread(this, tagSet).start();
            this.doIndex(req, rsp);
        }

        private String isInvalidTag(String name) {
            if (name == null || name.length() == 0) {
                return Messages.CVSSCM_TagIsEmpty();
            }
            char ch = name.charAt(0);
            if (!('A' <= ch && ch <= 'Z' || 'a' <= ch && ch <= 'z')) {
                return Messages.CVSSCM_TagNeedsToStartWithAlphabet();
            }
            for (char invalid : "$,.:;@".toCharArray()) {
                if (name.indexOf(invalid) < 0) continue;
                return Messages.CVSSCM_TagContainsIllegalChar(Character.valueOf(invalid));
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void perform(String tagName, TaskListener listener) {
            File destdir = null;
            try {
                destdir = Util.createTempDir();
                listener.getLogger().println(Messages.CVSSCM_ExpandingWorkspaceArchive(destdir));
                Expand e = new Expand();
                e.setProject(new Project());
                e.setDest(destdir);
                e.setSrc(CVSSCM.getArchiveFile(this.build));
                e.setTaskType("unzip");
                e.execute();
                listener.getLogger().println(Messages.CVSSCM_TaggingWorkspace());
                for (String m : CVSSCM.this.getAllModulesNormalized()) {
                    FilePath path = new FilePath(destdir).child(m);
                    boolean isDir = path.isDirectory();
                    ArgumentListBuilder cmd = new ArgumentListBuilder();
                    cmd.add(new String[]{CVSSCM.this.getDescriptor().getCvsExeOrDefault(), "tag"});
                    if (isDir) {
                        cmd.add("-R");
                    }
                    cmd.add(tagName);
                    if (!isDir) {
                        cmd.add(path.getName());
                        path = path.getParent();
                    }
                    if (CVSSCM.this.run((Launcher)new Launcher.LocalLauncher(listener), cmd, listener, path)) continue;
                    listener.getLogger().println(Messages.CVSSCM_TaggingFailed());
                    return;
                }
                this.onTagCompleted(tagName);
                this.build.save();
            }
            catch (Throwable e) {
                e.printStackTrace(listener.fatalError(e.getMessage()));
            }
            finally {
                try {
                    if (destdir != null) {
                        listener.getLogger().println("cleaning up " + destdir);
                        Util.deleteRecursive((File)destdir);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace(listener.fatalError(e.getMessage()));
                }
            }
        }

        private synchronized void onTagCompleted(String tagName) {
            this.tagName = this.tagName != null ? this.tagName + ' ' + tagName : tagName;
            this.workerThread = null;
        }

        public Descriptor<TagAction> getDescriptor() {
            return Hudson.getInstance().getDescriptorOrDie(((Object)((Object)this)).getClass());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class DescriptorImpl
    extends SCMDescriptor<CVSSCM>
    implements ModelObject {
        private String cvsPassFile;
        private String cvsExe;
        private boolean noCompression;
        private transient Map<String, RepositoryBrowser> browsers;
        private static final Pattern CVSROOT_PSERVER_PATTERN = Pattern.compile(":(ext|extssh|pserver):[^@:]+(:[^@:]+)?@[^:]+:(\\d+:)?.+");

        public DescriptorImpl() {
            super(CVSRepositoryBrowser.class);
            this.load();
        }

        protected void convert(Map<String, Object> oldPropertyBag) {
            this.cvsPassFile = (String)oldPropertyBag.get("cvspass");
        }

        public String getDisplayName() {
            return "CVS";
        }

        public SCM newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            CVSSCM scm = (CVSSCM)req.bindJSON(CVSSCM.class, formData);
            scm.repositoryBrowser = (CVSRepositoryBrowser)RepositoryBrowsers.createInstance(CVSRepositoryBrowser.class, (StaplerRequest)req, (JSONObject)formData, (String)"browser");
            return scm;
        }

        public String getCvspassFile() {
            String value = this.cvsPassFile;
            if (value == null) {
                value = "";
            }
            return value;
        }

        public String getCvsExe() {
            return this.cvsExe;
        }

        public void setCvsExe(String value) {
            this.cvsExe = value;
            this.save();
        }

        public String getCvsExeOrDefault() {
            if (Util.fixEmpty((String)this.cvsExe) == null) {
                return "cvs";
            }
            return this.cvsExe;
        }

        public void setCvspassFile(String value) {
            this.cvsPassFile = value;
            this.save();
        }

        public boolean isNoCompression() {
            return this.noCompression;
        }

        public boolean configure(StaplerRequest req, JSONObject o) {
            this.cvsPassFile = Util.fixEmptyAndTrim((String)o.getString("cvspassFile"));
            this.cvsExe = Util.fixEmptyAndTrim((String)o.getString("cvsExe"));
            this.noCompression = req.getParameter("cvs_noCompression") != null;
            this.save();
            return true;
        }

        public boolean isBrowserReusable(CVSSCM x, CVSSCM y) {
            return x.getCvsRoot().equals(y.getCvsRoot());
        }

        public Set<String> getAllCvsRoots() {
            TreeSet<String> r = new TreeSet<String>();
            for (AbstractProject p : Hudson.getInstance().getAllItems(AbstractProject.class)) {
                SCM scm = p.getScm();
                if (!(scm instanceof CVSSCM)) continue;
                CVSSCM cvsscm = (CVSSCM)scm;
                r.add(cvsscm.getCvsRoot());
            }
            return r;
        }

        public FormValidation doCheckCvspassFile(@QueryParameter String value) {
            if (!Hudson.getInstance().hasPermission(Hudson.ADMINISTER)) {
                return FormValidation.ok();
            }
            if ((value = Util.fixEmpty((String)value)) == null) {
                return FormValidation.ok();
            }
            File cvsPassFile = new File(value);
            if (cvsPassFile.exists()) {
                if (cvsPassFile.isDirectory()) {
                    return FormValidation.error((String)(cvsPassFile + " is a directory"));
                }
                return FormValidation.ok();
            }
            return FormValidation.error((String)"No such file exists");
        }

        public FormValidation doCheckCvsExe(@QueryParameter String value) {
            return FormValidation.validateExecutable((String)value);
        }

        public void doVersion(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException, InterruptedException {
            ByteBuffer baos = new ByteBuffer();
            try {
                Hudson.getInstance().createLauncher(TaskListener.NULL).launch().cmds(new String[]{this.getCvsExeOrDefault(), "--version"}).stdout((OutputStream)baos).join();
                rsp.setContentType("text/plain");
                baos.writeTo((OutputStream)rsp.getOutputStream());
            }
            catch (IOException e) {
                req.setAttribute("error", (Object)e);
                rsp.forward((Object)this, "versionCheckError", req);
            }
        }

        public FormValidation doCheckBranch(@QueryParameter String value) {
            String v = Util.fixNull((String)value);
            if (v.equals("HEAD")) {
                return FormValidation.error((String)Messages.CVSSCM_HeadIsNotBranch());
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckCvsRoot(@QueryParameter String value) throws IOException {
            String cvspass;
            File passfile;
            String v = Util.fixEmpty((String)value);
            if (v == null) {
                return FormValidation.error((String)Messages.CVSSCM_MissingCvsroot());
            }
            Matcher m = CVSROOT_PSERVER_PATTERN.matcher(v);
            if ((v.startsWith(":pserver") || v.startsWith(":ext")) && !m.matches()) {
                return FormValidation.error((String)Messages.CVSSCM_InvalidCvsroot());
            }
            if (v.startsWith(":pserver") && m.group(2) == null && (passfile = (cvspass = this.getCvspassFile()).equals("") ? new File(new File(System.getProperty("user.home")), ".cvspass") : new File(cvspass)).exists() && !this.scanCvsPassFile(passfile, v)) {
                return FormValidation.error((String)Messages.CVSSCM_PasswordNotSet());
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckExcludeRegions(@QueryParameter String value) {
            String v = Util.fixNull((String)value).trim();
            for (String region : v.split("[\\r\\n]+")) {
                try {
                    Pattern.compile(region);
                }
                catch (PatternSyntaxException e) {
                    return FormValidation.error((String)("Invalid regular expression. " + e.getMessage()));
                }
            }
            return FormValidation.ok();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean scanCvsPassFile(File passfile, String cvsroot) throws IOException {
            cvsroot = cvsroot + ' ';
            String cvsroot2 = "/1 " + cvsroot;
            BufferedReader in = new BufferedReader(new FileReader(passfile));
            try {
                String line;
                while ((line = in.readLine()) != null) {
                    int portIndex = line.indexOf(":2401/");
                    String line2 = "";
                    if (portIndex >= 0) {
                        line2 = line.substring(0, portIndex + 1) + line.substring(portIndex + 5);
                    }
                    if (!line.startsWith(cvsroot) && !line.startsWith(cvsroot2) && !line2.startsWith(cvsroot2)) continue;
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            finally {
                in.close();
            }
        }

        public void doPostPassword(StaplerRequest req, StaplerResponse rsp) throws IOException, InterruptedException {
            Hudson.getInstance().checkPermission(Hudson.ADMINISTER);
            String cvsroot = req.getParameter("cvsroot");
            String password = req.getParameter("password");
            if (cvsroot == null || password == null) {
                rsp.setStatus(400);
                return;
            }
            rsp.setContentType("text/plain");
            Proc proc = Hudson.getInstance().createLauncher(TaskListener.NULL).launch().cmds(new String[]{this.getCvsExeOrDefault(), "-d", cvsroot, "login"}).stdin((InputStream)new ByteArrayInputStream((password + "\n").getBytes())).stdout((OutputStream)rsp.getOutputStream()).start();
            proc.join();
        }

        class RepositoryBrowser {
            String diffURL;
            String browseURL;

            RepositoryBrowser() {
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class StickyDateCleanUpTask
    implements FilePath.FileCallable<Void> {
        private static final Pattern STICKY_DATE = Pattern.compile("D\\d\\d\\d\\d\\.\\d\\d\\.\\d\\d\\.\\d\\d\\.\\d\\d\\.\\d\\d");

        private StickyDateCleanUpTask() {
        }

        public Void invoke(File f, VirtualChannel channel) throws IOException {
            this.process(f);
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void process(File f) throws IOException {
            File[] children;
            String[] lines;
            String contents;
            File entries = new File(f, "CVS/Entries");
            if (!entries.exists()) {
                return;
            }
            boolean modified = false;
            try {
                contents = FileUtils.readFileToString((File)entries);
            }
            catch (IOException e) {
                LOGGER.log(Level.INFO, "Failed to parse " + entries, e);
                return;
            }
            StringBuilder newContents = new StringBuilder(contents.length());
            for (String line : lines = contents.split("\n")) {
                int idx = line.lastIndexOf(47);
                if (idx == -1) continue;
                String date = line.substring(idx + 1);
                if (STICKY_DATE.matcher(date.trim()).matches()) {
                    line = line.substring(0, idx + 1);
                    modified = true;
                }
                newContents.append(line).append('\n');
            }
            if (modified) {
                AtomicFileWriter w = new AtomicFileWriter(entries, null);
                try {
                    w.write(newContents.toString());
                    w.commit();
                }
                finally {
                    w.abort();
                }
            }
            if ((children = f.listFiles()) != null) {
                for (File child : children) {
                    this.process(child);
                }
            }
        }
    }

    static class BuildExceptionWithLog
    extends RuntimeException {
        final String errorOutput;
        private static final long serialVersionUID = 1L;

        public BuildExceptionWithLog(BuildException cause, String errorOutput) {
            super(cause);
            this.errorOutput = errorOutput;
        }
    }

    static class ChangeLogResult
    implements Serializable {
        boolean hadError;
        String errorOutput;
        private static final long serialVersionUID = 1L;

        public ChangeLogResult(boolean hadError, String errorOutput) {
            this.hadError = hadError;
            if (hadError) {
                this.errorOutput = errorOutput;
            }
        }
    }
}

