/*
 * Decompiled with CFR 0.152.
 */
package hudson.scm.browsers;

import hudson.Util;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.scm.CVSChangeLogSet;
import hudson.scm.CVSRepositoryBrowser;
import hudson.scm.RepositoryBrowser;
import hudson.scm.browsers.QueryBuilder;
import hudson.util.FormValidation;
import java.io.IOException;
import java.net.URL;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public final class FishEyeCVS
extends CVSRepositoryBrowser {
    public final URL url;
    private static final long serialVersionUID = 1L;

    @DataBoundConstructor
    public FishEyeCVS(URL url) {
        this.url = FishEyeCVS.normalizeToEndWithSlash((URL)url);
    }

    public URL getDiffLink(CVSChangeLogSet.File file) throws IOException {
        CVSChangeLogSet.Revision r = new CVSChangeLogSet.Revision(file.getRevision());
        CVSChangeLogSet.Revision p = r.getPrevious();
        if (p == null) {
            return null;
        }
        return new URL(this.url, FishEyeCVS.trimHeadSlash((String)file.getFullName()) + new QueryBuilder(this.url.getQuery()).add("r1=" + p).add("r2=" + r));
    }

    public URL getFileLink(CVSChangeLogSet.File file) throws IOException {
        return new URL(this.url, FishEyeCVS.trimHeadSlash((String)file.getFullName()) + new QueryBuilder(this.url.getQuery()));
    }

    public URL getChangeSetLink(CVSChangeLogSet.CVSChangeLog changeSet) throws IOException {
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DescriptorImpl
    extends Descriptor<RepositoryBrowser<?>> {
        private static final Pattern URL_PATTERN = Pattern.compile(".+/browse/[^/]+/");

        public String getDisplayName() {
            return "FishEye";
        }

        public FormValidation doCheckUrl(@QueryParameter String value) throws IOException, ServletException {
            if ((value = Util.fixEmpty((String)value)) == null) {
                return FormValidation.ok();
            }
            if (!value.endsWith("/")) {
                value = value + '/';
            }
            if (!URL_PATTERN.matcher(value).matches()) {
                return FormValidation.errorWithMarkup((String)"The URL should end like <tt>.../browse/foobar/</tt>");
            }
            if (!Hudson.getInstance().hasPermission(Hudson.ADMINISTER)) {
                return FormValidation.ok();
            }
            final String finalValue = value;
            return new FormValidation.URLCheck(){

                protected FormValidation check() throws IOException, ServletException {
                    try {
                        if (this.findText(this.open(new URL(finalValue)), "FishEye")) {
                            return FormValidation.ok();
                        }
                        return FormValidation.error((String)"This is a valid URL but it doesn't look like FishEye");
                    }
                    catch (IOException e) {
                        return this.handleIOException(finalValue, e);
                    }
                }
            }.check();
        }
    }
}

