/*
 * Decompiled with CFR 0.152.
 */
package hudson.org.apache.tools.ant.taskdefs.cvslib;

import hudson.org.apache.tools.ant.taskdefs.cvslib.RCSFile;
import java.util.Date;
import java.util.Vector;

class CVSEntry {
    private Date m_date;
    private String m_author;
    private final String m_comment;
    private final Vector<RCSFile> m_files = new Vector();

    public CVSEntry(Date date, String author, String comment) {
        this.m_date = date;
        this.m_author = author;
        this.m_comment = comment;
    }

    public void addFile(String file, String fullName, String revision, String previousRevision, String branch, boolean dead) {
        this.m_files.addElement(new RCSFile(file, fullName, revision, previousRevision, branch, dead));
    }

    Date getDate() {
        return this.m_date;
    }

    void setAuthor(String author) {
        this.m_author = author;
    }

    String getAuthor() {
        return this.m_author;
    }

    String getComment() {
        return this.m_comment;
    }

    Vector getFiles() {
        return this.m_files;
    }

    public boolean containsBranch(String branch) {
        for (RCSFile file : this.m_files) {
            String b = file.getBranch();
            if (b == null && branch == null) {
                return true;
            }
            if (b == null || branch == null || !b.equals(branch)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return '[' + this.getAuthor() + "," + this.getDate() + "," + this.getFiles() + "," + this.getComment() + ']';
    }
}

