/*
 * Decompiled with CFR 0.152.
 */
package hudson.org.apache.tools.ant.taskdefs.cvslib;

import hudson.org.apache.tools.ant.taskdefs.AbstractCvsTask;
import hudson.org.apache.tools.ant.taskdefs.cvslib.CVSEntry;
import hudson.org.apache.tools.ant.taskdefs.cvslib.ChangeLogParser;
import hudson.org.apache.tools.ant.taskdefs.cvslib.ChangeLogWriter;
import hudson.org.apache.tools.ant.taskdefs.cvslib.CvsUser;
import hudson.org.apache.tools.ant.taskdefs.cvslib.RedirectingOutputStream;
import hudson.org.apache.tools.ant.taskdefs.cvslib.RedirectingStreamHandler;
import hudson.util.ForkOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.ExecuteStreamHandler;
import org.apache.tools.ant.taskdefs.LogOutputStream;
import org.apache.tools.ant.taskdefs.cvslib.CvsVersion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChangeLogTask
extends AbstractCvsTask {
    private File m_usersFile;
    private Vector m_cvsUsers = new Vector();
    private File m_dir;
    private OutputStream m_output;
    private Date m_start;
    private Date m_stop;
    private String branch;
    private List<String> m_filesets = new ArrayList();
    private ChangeLogParser parser;
    private RedirectingStreamHandler handler;
    private static final long VERSION_1_11_2 = 11102L;
    private static final long MULTIPLY = 100L;

    public void setDir(File dir) {
        this.m_dir = dir;
    }

    public File getDir() {
        return this.m_dir;
    }

    public void setDeststream(OutputStream destfile) {
        this.m_output = destfile;
    }

    public void setUsersfile(File usersFile) {
        this.m_usersFile = usersFile;
    }

    public void addUser(CvsUser user) {
        this.m_cvsUsers.addElement(user);
    }

    public void setStart(Date start) {
        this.m_start = start;
    }

    public void setBranch(String branch) {
        this.branch = branch;
    }

    public void setEnd(Date stop) {
        this.m_stop = stop;
    }

    public void setDaysinpast(int days) {
        long time = System.currentTimeMillis() - (long)days * 24L * 60L * 60L * 1000L;
        this.setStart(new Date(time));
    }

    public void addFile(String fileName) {
        this.m_filesets.add(fileName);
    }

    public void setFile(List<String> files) {
        this.m_filesets = files;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BuildException {
        File savedDir = this.m_dir;
        try {
            this.validate();
            Properties userList = new Properties();
            this.loadUserlist(userList);
            Enumeration e = this.m_cvsUsers.elements();
            while (e.hasMoreElements()) {
                CvsUser user = (CvsUser)e.nextElement();
                user.validate();
                userList.put(user.getUserID(), user.getDisplayname());
            }
            this.setCommand("log");
            if (this.m_filesets.isEmpty() || this.m_filesets.size() > 10) {
                CvsVersion myCvsVersion = new CvsVersion();
                myCvsVersion.setProject(this.getProject());
                myCvsVersion.setTaskName("cvsversion");
                myCvsVersion.setCvsRoot(this.getCvsRoot());
                myCvsVersion.setCvsRsh(this.getCvsRsh());
                myCvsVersion.setPassfile(this.getPassFile());
                myCvsVersion.setDest(this.m_dir);
                myCvsVersion.execute();
                if (this.supportsCvsLogWithSOption(myCvsVersion.getClientVersion()) && this.supportsCvsLogWithSOption(myCvsVersion.getServerVersion())) {
                    this.addCommandArgument("-S");
                }
            }
            if (null != this.m_start) {
                SimpleDateFormat outputDate = new SimpleDateFormat("yyyy-MM-dd");
                Date safeStart = new Date(this.m_start.getTime() - 86400000L);
                String dateRange = ">=" + outputDate.format(safeStart);
                this.addCommandArgument("-d");
                this.addCommandArgument(dateRange);
            }
            if (!this.m_filesets.isEmpty()) {
                this.addCommandArgument("--");
                for (String file : this.m_filesets) {
                    this.addCommandArgument(file);
                }
            }
            this.parser = new ChangeLogParser(this);
            this.log("Running " + this.getCommand() + " at " + this.m_dir, 3);
            this.setDest(this.m_dir);
            try {
                super.execute();
            }
            finally {
                String errors = this.handler.getErrors();
                if (null != errors && errors.length() != 0) {
                    this.log(errors, 0);
                }
            }
            CVSEntry[] entrySet = this.parser.getEntrySetAsArray();
            CVSEntry[] filteredEntrySet = this.filterEntrySet(entrySet);
            this.replaceAuthorIdWithName(userList, filteredEntrySet);
            this.writeChangeLog(filteredEntrySet);
        }
        finally {
            this.m_dir = savedDir;
        }
    }

    protected ExecuteStreamHandler getExecuteStreamHandler(InputStream input) {
        this.handler = new RedirectingStreamHandler((OutputStream)new ForkOutputStream((OutputStream)new RedirectingOutputStream(this.parser), (OutputStream)new LogOutputStream((Task)this, 3)), (OutputStream)new LogOutputStream((Task)this, 1), input);
        return this.handler;
    }

    private boolean supportsCvsLogWithSOption(String versionString) {
        if (versionString == null) {
            return false;
        }
        StringTokenizer mySt = new StringTokenizer(versionString, ".");
        long counter = 10000L;
        long version = 0L;
        while (mySt.hasMoreTokens()) {
            int i;
            int startpos;
            String s = mySt.nextToken();
            for (startpos = 0; startpos < s.length() && !Character.isDigit(s.charAt(startpos)); ++startpos) {
            }
            for (i = startpos; i < s.length() && Character.isDigit(s.charAt(i)); ++i) {
            }
            String s2 = s.substring(startpos, i);
            version += counter * Long.parseLong(s2);
            if (counter == 1L) break;
            counter /= 100L;
        }
        return version >= 11102L;
    }

    private void validate() throws BuildException {
        if (null == this.m_dir) {
            this.m_dir = this.getProject().getBaseDir();
        }
        if (null == this.m_output) {
            String message = "Destfile must be set.";
            throw new BuildException("Destfile must be set.");
        }
        if (!this.m_dir.exists()) {
            String message = "Cannot find base dir " + this.m_dir.getAbsolutePath();
            throw new BuildException(message);
        }
        if (null != this.m_usersFile && !this.m_usersFile.exists()) {
            String message = "Cannot find user lookup list " + this.m_usersFile.getAbsolutePath();
            throw new BuildException(message);
        }
    }

    private void loadUserlist(Properties userList) throws BuildException {
        if (null != this.m_usersFile) {
            try {
                userList.load(new FileInputStream(this.m_usersFile));
            }
            catch (IOException ioe) {
                throw new BuildException(ioe.toString(), (Throwable)ioe);
            }
        }
    }

    private CVSEntry[] filterEntrySet(CVSEntry[] entrySet) {
        this.log("Filtering entries", 3);
        Vector<CVSEntry> results = new Vector<CVSEntry>();
        for (int i = 0; i < entrySet.length; ++i) {
            CVSEntry cvsEntry = entrySet[i];
            Date date = cvsEntry.getDate();
            if (date == null) {
                this.log("Filtering out " + cvsEntry + " because it has no date", 3);
                continue;
            }
            if (null != this.m_start && this.m_start.after(date)) {
                this.log("Filtering out " + cvsEntry + " because it's too early compare to " + this.m_start, 3);
                continue;
            }
            if (null != this.m_stop && this.m_stop.before(date)) {
                this.log("Filtering out " + cvsEntry + " because it's too late compare to " + this.m_stop, 3);
                continue;
            }
            if (null == this.getTag() && !cvsEntry.containsBranch(this.branch)) {
                this.log("Filtering out " + cvsEntry + " because it didn't match the branch '" + this.branch + "'", 3);
                continue;
            }
            results.addElement(cvsEntry);
        }
        Object[] resultArray = new CVSEntry[results.size()];
        results.copyInto(resultArray);
        return resultArray;
    }

    private void replaceAuthorIdWithName(Properties userList, CVSEntry[] entrySet) {
        for (int i = 0; i < entrySet.length; ++i) {
            CVSEntry entry = entrySet[i];
            if (!userList.containsKey(entry.getAuthor())) continue;
            entry.setAuthor(userList.getProperty(entry.getAuthor()));
        }
    }

    private void writeChangeLog(CVSEntry[] entrySet) throws BuildException {
        OutputStream output = null;
        try {
            output = this.m_output;
            PrintWriter writer = new PrintWriter(new OutputStreamWriter(output, "UTF-8"));
            ChangeLogWriter serializer = new ChangeLogWriter();
            serializer.printChangeLog(writer, entrySet);
        }
        catch (UnsupportedEncodingException uee) {
            this.getProject().log(uee.toString(), 0);
        }
        catch (IOException ioe) {
            throw new BuildException(ioe.toString(), (Throwable)ioe);
        }
        finally {
            if (null != output) {
                try {
                    output.close();
                }
                catch (IOException ioe) {}
            }
        }
    }
}

