/*
 * Decompiled with CFR 0.152.
 */
package hudson.scm;

import hudson.model.AbstractBuild;
import hudson.scm.CVSChangeLogSet;
import hudson.scm.ChangeLogSet;
import hudson.util.Digester2;
import hudson.util.IOException2;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CVSChangeLogSet
extends ChangeLogSet<CVSChangeLog> {
    private static final Logger LOGGER = Logger.getLogger(CVSChangeLogSet.class.getName());
    private List<CVSChangeLog> logs;

    public CVSChangeLogSet(AbstractBuild<?, ?> build, List<CVSChangeLog> logs) {
        super(build);
        this.logs = Collections.unmodifiableList(logs);
        for (CVSChangeLog log : logs) {
            log.setParent((ChangeLogSet)this);
        }
    }

    public List<CVSChangeLog> getLogs() {
        return this.logs;
    }

    public boolean isEmptySet() {
        return this.logs.isEmpty();
    }

    public Iterator<CVSChangeLog> iterator() {
        return this.logs.iterator();
    }

    public String getKind() {
        return "cvs";
    }

    public static CVSChangeLogSet parse(AbstractBuild build, java.io.File f) throws IOException, SAXException {
        Digester2 digester = new Digester2();
        ArrayList r = new ArrayList();
        digester.push(r);
        digester.addObjectCreate("*/entry", CVSChangeLog.class);
        digester.addBeanPropertySetter("*/entry/date");
        digester.addBeanPropertySetter("*/entry/time");
        digester.addBeanPropertySetter("*/entry/author", "user");
        digester.addBeanPropertySetter("*/entry/msg");
        digester.addSetNext("*/entry", "add");
        digester.addObjectCreate("*/entry/file", File.class);
        digester.addBeanPropertySetter("*/entry/file/name");
        digester.addBeanPropertySetter("*/entry/file/fullName");
        digester.addBeanPropertySetter("*/entry/file/revision");
        digester.addBeanPropertySetter("*/entry/file/prevrevision");
        digester.addCallMethod("*/entry/file/dead", "setDead");
        digester.addSetNext("*/entry/file", "addFile");
        try {
            digester.parse(f);
        }
        catch (IOException e) {
            throw new IOException2("Failed to parse " + f, (Throwable)e);
        }
        catch (SAXException e) {
            throw new IOException2("Failed to parse " + f, (Throwable)e);
        }
        for (int i = r.size() - 1; i >= 0; --i) {
            CVSChangeLog log = (CVSChangeLog)r.get(i);
            boolean merged = false;
            if (!log.isComplete()) {
                r.remove(log);
                continue;
            }
            for (int j = 0; j < i; ++j) {
                CVSChangeLog c = (CVSChangeLog)r.get(j);
                if (!c.canBeMergedWith(log)) continue;
                c.merge(log);
                merged = true;
                break;
            }
            if (!merged) continue;
            r.remove(log);
        }
        return new CVSChangeLogSet(build, r);
    }

    static /* synthetic */ Logger access$000() {
        return LOGGER;
    }
}

