/*
 * Decompiled with CFR 0.152.
 */
package hudson.org.apache.tools.ant.taskdefs.cvslib;

import hudson.org.apache.tools.ant.taskdefs.cvslib.CVSEntry;
import hudson.org.apache.tools.ant.taskdefs.cvslib.ChangeLogTask;
import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;

class ChangeLogParser {
    private static final int GET_FILE = 1;
    private static final int GET_DATE = 2;
    private static final int GET_COMMENT = 3;
    private static final int GET_REVISION = 4;
    private static final int GET_PREVIOUS_REV = 5;
    private static final int GET_SYMBOLIC_NAMES = 6;
    private final SimpleDateFormat[] c_inputDate = new SimpleDateFormat[]{new SimpleDateFormat("yyyy/MM/dd HH:mm:ss Z"), new SimpleDateFormat("yyyy-MM-dd HH:mm:ss Z"), new SimpleDateFormat("yyyy/MM/dd HH:mm:ss"), new SimpleDateFormat("yyyy-MM-dd HH:mm:ss")};
    private String m_file;
    private String m_fullName;
    private String m_date;
    private String m_author;
    private String m_comment;
    private String m_revision;
    private String m_previousRevision;
    private final Map<String, String> branches;
    private boolean m_dead;
    private int m_status;
    private final Hashtable<String, CVSEntry> m_entries;
    private final ChangeLogTask owner;
    private boolean dead;
    private String previousLine;
    private static final Pattern DOT_PATTERN = Pattern.compile("(([0-9]+\\.)+)0\\.([0-9]+)");
    private static final Logger LOGGER = Logger.getLogger(ChangeLogParser.class.getName());

    public ChangeLogParser(ChangeLogTask owner) {
        TimeZone utc = TimeZone.getTimeZone("UTC");
        for (SimpleDateFormat df : this.c_inputDate) {
            df.setTimeZone(utc);
        }
        this.branches = new HashMap<String, String>();
        this.m_status = 1;
        this.m_entries = new Hashtable();
        this.dead = false;
        this.previousLine = null;
        this.owner = owner;
    }

    CVSEntry[] getEntrySetAsArray() {
        CVSEntry[] array = new CVSEntry[this.m_entries.size()];
        Enumeration<CVSEntry> e = this.m_entries.elements();
        int i = 0;
        while (e.hasMoreElements()) {
            array[i++] = e.nextElement();
        }
        return array;
    }

    public void stdout(String line) {
        if (this.dead) {
            return;
        }
        try {
            switch (this.m_status) {
                case 1: {
                    this.reset();
                    this.processFile(line);
                    break;
                }
                case 6: {
                    this.processSymbolicName(line);
                    break;
                }
                case 4: {
                    this.processRevision(line);
                    break;
                }
                case 2: {
                    this.processDate(line);
                    break;
                }
                case 3: {
                    this.processComment(line);
                    break;
                }
                case 5: {
                    this.processGetPreviousRevision(line);
                }
            }
        }
        catch (Exception e) {
            this.dead = true;
        }
    }

    private void processComment(String line) {
        String lineSeparator = System.getProperty("line.separator");
        if (line.startsWith("======")) {
            int end = this.m_comment.length() - lineSeparator.length();
            this.m_comment = this.m_comment.substring(0, end);
            this.saveEntry();
            this.m_status = 1;
        } else if (null != this.previousLine && this.previousLine.startsWith("----------------------------")) {
            if (line.startsWith("revision")) {
                int end = this.m_comment.length() - lineSeparator.length();
                this.m_comment = this.m_comment.substring(0, end);
                this.m_status = 5;
                this.processGetPreviousRevision(line);
            } else {
                this.m_comment = this.m_comment + this.previousLine + lineSeparator + line + lineSeparator;
            }
            this.previousLine = null;
        } else if (line.startsWith("----------------------------")) {
            if (null != this.previousLine) {
                this.m_comment = this.m_comment + this.previousLine + lineSeparator;
            }
            this.previousLine = line;
        } else {
            this.m_comment = this.m_comment + line + lineSeparator;
        }
    }

    private void processFile(String line) {
        if (line.startsWith("Working file:")) {
            this.m_file = line.substring(14, line.length());
            File repo = new File(new File(this.owner.getDir(), this.m_file).getParentFile(), "CVS/Repository");
            try {
                String module = FileUtils.readFileToString((File)repo, null);
                String simpleName = this.m_file.substring(this.m_file.lastIndexOf(47) + 1);
                this.m_fullName = '/' + module.trim() + '/' + simpleName;
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "Failed to read CVS/Repository at " + repo, e);
                this.m_fullName = null;
            }
            this.m_status = 6;
        }
    }

    private void processSymbolicName(String line) {
        if (line.startsWith("\t")) {
            int idx = (line = line.trim()).lastIndexOf(58);
            if (idx < 0) {
                return;
            }
            String symbol = line.substring(0, idx);
            Matcher m = DOT_PATTERN.matcher(line.substring(idx + 2));
            if (!m.matches()) {
                return;
            }
            this.branches.put(m.group(1) + m.group(3) + '.', symbol);
        } else if (line.startsWith("keyword substitution:")) {
            this.m_status = 4;
        }
    }

    private void processRevision(String line) {
        if (line.startsWith("revision")) {
            this.m_revision = line.substring(9);
            this.m_status = 2;
        } else if (line.startsWith("======")) {
            this.m_status = 1;
        }
    }

    private void processDate(String line) {
        if (line.startsWith("date:")) {
            int idx = line.indexOf(";");
            this.m_date = line.substring(6, idx);
            String lineData = line.substring(idx + 1);
            this.m_author = lineData.substring(10, lineData.indexOf(";"));
            this.m_status = 3;
            this.m_dead = lineData.indexOf("state: dead;") != -1;
            this.m_comment = "";
        }
    }

    private void processGetPreviousRevision(String line) {
        if (!line.startsWith("revision")) {
            throw new IllegalStateException("Unexpected line from CVS: " + line);
        }
        this.m_previousRevision = line.substring(9);
        this.saveEntry();
        this.m_revision = this.m_previousRevision;
        this.m_status = 2;
    }

    private void saveEntry() {
        CVSEntry entry;
        String entryKey = this.m_date + this.m_author + this.m_comment;
        if (!this.m_entries.containsKey(entryKey)) {
            entry = new CVSEntry(this.parseDate(this.m_date), this.m_author, this.m_comment);
            this.m_entries.put(entryKey, entry);
        } else {
            entry = this.m_entries.get(entryKey);
        }
        String branch = this.findBranch(this.m_revision);
        this.owner.log("Recorded a change: " + this.m_date + ',' + this.m_author + ',' + this.m_revision + "(branch=" + branch + ")," + this.m_comment, 3);
        entry.addFile(this.m_file, this.m_fullName, this.m_revision, this.m_previousRevision, branch, this.m_dead);
    }

    private String findBranch(String revision) {
        if (revision == null) {
            return null;
        }
        for (Map.Entry<String, String> e : this.branches.entrySet()) {
            if (!revision.startsWith(e.getKey()) || revision.substring(e.getKey().length()).indexOf(46) != -1) continue;
            return e.getValue();
        }
        return null;
    }

    private Date parseDate(String date) {
        for (SimpleDateFormat df : this.c_inputDate) {
            try {
                return df.parse(date);
            }
            catch (ParseException e) {
                LOGGER.log(Level.FINER, "Couldn't convert " + date + " to format " + df);
            }
        }
        this.owner.log("Failed to parse " + date + "\n", 0);
        return null;
    }

    private void reset() {
        this.m_file = null;
        this.m_fullName = null;
        this.m_date = null;
        this.m_author = null;
        this.m_comment = null;
        this.m_revision = null;
        this.m_previousRevision = null;
        this.m_dead = false;
        this.branches.clear();
    }
}

