/*
 * Decompiled with CFR 0.152.
 */
package hudson.scm;

import hudson.model.AbstractBuild;
import hudson.model.User;
import hudson.scm.CVSSCM;
import hudson.scm.ChangeLogSet;
import hudson.scm.EditType;
import hudson.scm.SCM;
import hudson.util.Digester2;
import hudson.util.IOException2;
import java.io.IOException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CVSChangeLogSet
extends ChangeLogSet<CVSChangeLog> {
    private static final Logger LOGGER = Logger.getLogger(CVSChangeLogSet.class.getName());
    private List<CVSChangeLog> logs;

    public CVSChangeLogSet(AbstractBuild<?, ?> build, List<CVSChangeLog> logs) {
        super(build);
        this.logs = Collections.unmodifiableList(logs);
        for (CVSChangeLog log : logs) {
            log.setParent(this);
        }
    }

    public List<CVSChangeLog> getLogs() {
        return this.logs;
    }

    public boolean isEmptySet() {
        return this.logs.isEmpty();
    }

    public Iterator<CVSChangeLog> iterator() {
        return this.logs.iterator();
    }

    public String getKind() {
        return "cvs";
    }

    public static CVSChangeLogSet parse(AbstractBuild build, java.io.File f) throws IOException, SAXException {
        Digester2 digester = new Digester2();
        ArrayList<CVSChangeLog> r = new ArrayList<CVSChangeLog>();
        digester.push(r);
        digester.addObjectCreate("*/entry", CVSChangeLog.class);
        digester.addBeanPropertySetter("*/entry/date");
        digester.addBeanPropertySetter("*/entry/time");
        digester.addBeanPropertySetter("*/entry/author", "user");
        digester.addBeanPropertySetter("*/entry/msg");
        digester.addSetNext("*/entry", "add");
        digester.addObjectCreate("*/entry/file", File.class);
        digester.addBeanPropertySetter("*/entry/file/name");
        digester.addBeanPropertySetter("*/entry/file/fullName");
        digester.addBeanPropertySetter("*/entry/file/revision");
        digester.addBeanPropertySetter("*/entry/file/prevrevision");
        digester.addCallMethod("*/entry/file/dead", "setDead");
        digester.addSetNext("*/entry/file", "addFile");
        try {
            digester.parse(f);
        }
        catch (IOException e) {
            throw new IOException2("Failed to parse " + f, (Throwable)e);
        }
        catch (SAXException e) {
            throw new IOException2("Failed to parse " + f, (Throwable)e);
        }
        for (int i = r.size() - 1; i >= 0; --i) {
            CVSChangeLog log = (CVSChangeLog)((Object)r.get(i));
            boolean merged = false;
            if (!log.isComplete()) {
                r.remove((Object)log);
                continue;
            }
            for (int j = 0; j < i; ++j) {
                CVSChangeLog c = r.get(j);
                if (!c.canBeMergedWith(log)) continue;
                c.merge(log);
                merged = true;
                break;
            }
            if (!merged) continue;
            r.remove((Object)log);
        }
        return new CVSChangeLogSet(build, r);
    }

    public static class Revision {
        public final int[] numbers;

        public Revision(int[] numbers) {
            this.numbers = numbers;
            assert (numbers.length % 2 == 0);
        }

        public Revision(String s) {
            String[] tokens = s.split("\\.");
            this.numbers = new int[tokens.length];
            for (int i = 0; i < tokens.length; ++i) {
                this.numbers[i] = Integer.parseInt(tokens[i]);
            }
            assert (this.numbers.length % 2 == 0);
        }

        public Revision getPrevious() {
            if (this.numbers[this.numbers.length - 1] == 1) {
                int[] p = new int[this.numbers.length - 2];
                System.arraycopy(this.numbers, 0, p, 0, p.length);
                if (p.length == 0) {
                    return null;
                }
                return new Revision(p);
            }
            int[] p = (int[])this.numbers.clone();
            int n = p.length - 1;
            p[n] = p[n] - 1;
            return new Revision(p);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            for (int n : this.numbers) {
                if (buf.length() > 0) {
                    buf.append('.');
                }
                buf.append(n);
            }
            return buf.toString();
        }
    }

    @ExportedBean(defaultVisibility=999)
    public static class File
    implements ChangeLogSet.AffectedFile {
        private String name;
        private String fullName;
        private String revision;
        private String prevrevision;
        private boolean dead;
        private CVSChangeLog parent;

        public String getPath() {
            return this.getName();
        }

        @Exported
        public String getName() {
            return this.name;
        }

        @Exported
        public String getFullName() {
            if (this.fullName == null) {
                CVSSCM cvsscm;
                SCM scm = this.parent.getParent().build.getProject().getScm();
                this.fullName = scm instanceof CVSSCM ? ((cvsscm = (CVSSCM)scm).isFlatten() ? '/' + cvsscm.getAllModules() + '/' + this.name : '/' + this.name) : '/' + this.name;
            }
            return this.fullName;
        }

        public void setFullName(String fullName) {
            this.fullName = fullName;
        }

        public String getSimpleName() {
            int idx = this.name.lastIndexOf(47);
            if (idx > 0) {
                return this.name.substring(idx + 1);
            }
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        @Exported
        public String getRevision() {
            return this.revision;
        }

        public void setRevision(String revision) {
            this.revision = revision;
        }

        @Exported
        public String getPrevrevision() {
            return this.prevrevision;
        }

        public void setPrevrevision(String prevrevision) {
            this.prevrevision = prevrevision;
        }

        @Exported
        public boolean isDead() {
            return this.dead;
        }

        public void setDead() {
            this.dead = true;
        }

        @Exported
        public EditType getEditType() {
            if (this.dead) {
                return EditType.DELETE;
            }
            if (this.revision.equals("1.1")) {
                return EditType.ADD;
            }
            return EditType.EDIT;
        }

        public CVSChangeLog getParent() {
            return this.parent;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CVSChangeLog
    extends ChangeLogSet.Entry {
        private String date;
        private String time;
        private User author;
        private String msg;
        private final List<File> files = new ArrayList<File>();

        public boolean isComplete() {
            return this.date != null && this.time != null && this.msg != null;
        }

        public boolean canBeMergedWith(CVSChangeLog that) {
            if (!this.date.equals(that.date)) {
                return false;
            }
            if (!this.time.equals(that.time)) {
                return false;
            }
            if (this.author == null || that.author == null || !this.author.equals(that.author)) {
                return false;
            }
            return this.msg.equals(that.msg);
        }

        protected void setParent(ChangeLogSet parent) {
            LOGGER.log(Level.FINEST, "Set parent " + parent);
            super.setParent(parent);
        }

        public void merge(CVSChangeLog that) {
            this.files.addAll(that.files);
            for (File f : that.files) {
                f.parent = this;
            }
        }

        @Exported
        public String getDate() {
            return this.date;
        }

        public void setDate(String date) {
            this.date = date;
        }

        @Exported
        public String getTime() {
            return this.time;
        }

        public void setTime(String time) {
            this.time = time;
        }

        @Exported
        public User getAuthor() {
            if (this.author == null) {
                return User.getUnknown();
            }
            return this.author;
        }

        public Collection<String> getAffectedPaths() {
            return new AbstractList<String>(){

                @Override
                public String get(int index) {
                    return ((File)CVSChangeLog.this.files.get(index)).getName();
                }

                @Override
                public int size() {
                    return CVSChangeLog.this.files.size();
                }
            };
        }

        public void setUser(String author) {
            this.author = User.get((String)author);
        }

        @Exported
        public String getUser() {
            return this.author.getDisplayName();
        }

        @Exported
        public String getMsg() {
            return this.msg;
        }

        public void setMsg(String msg) {
            this.msg = msg;
        }

        public void addFile(File f) {
            f.parent = this;
            this.files.add(f);
        }

        @Exported
        public List<File> getFiles() {
            return this.files;
        }

        public Collection<File> getAffectedFiles() {
            return this.files;
        }
    }
}

