// CHECKSTYLE:OFF

package hudson.scm.cvs;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;

@SuppressWarnings({
    "",
    "PMD"
})
public class Messages {

    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Upstream build not found for: {0}
     * 
     */
    public static String CVSSCM_NoUpstreamBuildFound(Object arg1) {
        return holder.format("CVSSCM.NoUpstreamBuildFound", arg1);
    }

    /**
     * Upstream build not found for: {0}
     * 
     */
    public static Localizable _CVSSCM_NoUpstreamBuildFound(Object arg1) {
        return new Localizable(holder, "CVSSCM.NoUpstreamBuildFound", arg1);
    }

    /**
     * Invalid CVSROOT string
     * 
     */
    public static String CVSSCM_InvalidCvsroot() {
        return holder.format("CVSSCM.InvalidCvsroot");
    }

    /**
     * Invalid CVSROOT string
     * 
     */
    public static Localizable _CVSSCM_InvalidCvsroot() {
        return new Localizable(holder, "CVSSCM.InvalidCvsroot");
    }

    /**
     * Technically, HEAD is not a branch in CVS. Leave this field empty to build the trunk.
     * 
     */
    public static String CVSSCM_HeadIsNotBranch() {
        return holder.format("CVSSCM.HeadIsNotBranch");
    }

    /**
     * Technically, HEAD is not a branch in CVS. Leave this field empty to build the trunk.
     * 
     */
    public static Localizable _CVSSCM_HeadIsNotBranch() {
        return new Localizable(holder, "CVSSCM.HeadIsNotBranch");
    }

    /**
     * CVSROOT is mandatory
     * 
     */
    public static String CVSSCM_MissingCvsroot() {
        return holder.format("CVSSCM.MissingCvsroot");
    }

    /**
     * CVSROOT is mandatory
     * 
     */
    public static Localizable _CVSSCM_MissingCvsroot() {
        return new Localizable(holder, "CVSSCM.MissingCvsroot");
    }

    /**
     * Tag this build
     * 
     */
    public static String CVSSCM_TagThisBuild() {
        return holder.format("CVSSCM.TagThisBuild");
    }

    /**
     * Tag this build
     * 
     */
    public static Localizable _CVSSCM_TagThisBuild() {
        return new Localizable(holder, "CVSSCM.TagThisBuild");
    }

    /**
     * tagging failed
     * 
     */
    public static String CVSSCM_TaggingFailed() {
        return holder.format("CVSSCM.TaggingFailed");
    }

    /**
     * tagging failed
     * 
     */
    public static Localizable _CVSSCM_TaggingFailed() {
        return new Localizable(holder, "CVSSCM.TaggingFailed");
    }

    /**
     * Tag needs to start with alphabet
     * 
     */
    public static String CVSSCM_TagNeedsToStartWithAlphabet() {
        return holder.format("CVSSCM.TagNeedsToStartWithAlphabet");
    }

    /**
     * Tag needs to start with alphabet
     * 
     */
    public static Localizable _CVSSCM_TagNeedsToStartWithAlphabet() {
        return new Localizable(holder, "CVSSCM.TagNeedsToStartWithAlphabet");
    }

    /**
     * Tag is empty
     * 
     */
    public static String CVSSCM_TagIsEmpty() {
        return holder.format("CVSSCM.TagIsEmpty");
    }

    /**
     * Tag is empty
     * 
     */
    public static Localizable _CVSSCM_TagIsEmpty() {
        return new Localizable(holder, "CVSSCM.TagIsEmpty");
    }

    /**
     * Tagging {0} as {1}
     * 
     */
    public static String CVSSCM_TagginXasY(Object arg1, Object arg2) {
        return holder.format("CVSSCM.TagginXasY", arg1, arg2);
    }

    /**
     * Tagging {0} as {1}
     * 
     */
    public static Localizable _CVSSCM_TagginXasY(Object arg1, Object arg2) {
        return new Localizable(holder, "CVSSCM.TagginXasY", arg1, arg2);
    }

    /**
     * expanding the workspace archive into {0}
     * 
     */
    public static String CVSSCM_ExpandingWorkspaceArchive(Object arg1) {
        return holder.format("CVSSCM.ExpandingWorkspaceArchive", arg1);
    }

    /**
     * expanding the workspace archive into {0}
     * 
     */
    public static Localizable _CVSSCM_ExpandingWorkspaceArchive(Object arg1) {
        return new Localizable(holder, "CVSSCM.ExpandingWorkspaceArchive", arg1);
    }

    /**
     * CVS tags
     * 
     */
    public static String CVSSCM_DisplayName2() {
        return holder.format("CVSSCM.DisplayName2");
    }

    /**
     * CVS tags
     * 
     */
    public static Localizable _CVSSCM_DisplayName2() {
        return new Localizable(holder, "CVSSCM.DisplayName2");
    }

    /**
     * CVS tag
     * 
     */
    public static String CVSSCM_DisplayName1() {
        return holder.format("CVSSCM.DisplayName1");
    }

    /**
     * CVS tag
     * 
     */
    public static Localizable _CVSSCM_DisplayName1() {
        return new Localizable(holder, "CVSSCM.DisplayName1");
    }

    /**
     * tagging the workspace
     * 
     */
    public static String CVSSCM_TaggingWorkspace() {
        return holder.format("CVSSCM.TaggingWorkspace");
    }

    /**
     * tagging the workspace
     * 
     */
    public static Localizable _CVSSCM_TaggingWorkspace() {
        return new Localizable(holder, "CVSSCM.TaggingWorkspace");
    }

    /**
     * No valid tag name given for {0} : {1}
     * 
     */
    public static String CVSSCM_NoValidTagNameGivenFor(Object arg1, Object arg2) {
        return holder.format("CVSSCM.NoValidTagNameGivenFor", arg1, arg2);
    }

    /**
     * No valid tag name given for {0} : {1}
     * 
     */
    public static Localizable _CVSSCM_NoValidTagNameGivenFor(Object arg1, Object arg2) {
        return new Localizable(holder, "CVSSCM.NoValidTagNameGivenFor", arg1, arg2);
    }

    /**
     * It doesn''t look like this CVSROOT has its password set.
     * 
     */
    public static String CVSSCM_PasswordNotSet() {
        return holder.format("CVSSCM.PasswordNotSet");
    }

    /**
     * It doesn''t look like this CVSROOT has its password set.
     * 
     */
    public static Localizable _CVSSCM_PasswordNotSet() {
        return new Localizable(holder, "CVSSCM.PasswordNotSet");
    }

    /**
     * Tag contains illegal ''{0}'' character
     * 
     */
    public static String CVSSCM_TagContainsIllegalChar(Object arg1) {
        return holder.format("CVSSCM.TagContainsIllegalChar", arg1);
    }

    /**
     * Tag contains illegal ''{0}'' character
     * 
     */
    public static Localizable _CVSSCM_TagContainsIllegalChar(Object arg1) {
        return new Localizable(holder, "CVSSCM.TagContainsIllegalChar", arg1);
    }

    /**
     * Workspace is inconsistent with configuration. Scheduling a new build: {0}
     * 
     */
    public static String CVSSCM_WorkspaceInconsistent(Object arg1) {
        return holder.format("CVSSCM.WorkspaceInconsistent", arg1);
    }

    /**
     * Workspace is inconsistent with configuration. Scheduling a new build: {0}
     * 
     */
    public static Localizable _CVSSCM_WorkspaceInconsistent(Object arg1) {
        return new Localizable(holder, "CVSSCM.WorkspaceInconsistent", arg1);
    }

    /**
     * No such job exists: {0}
     * 
     */
    public static String CVSSCM_NoSuchJobExists(Object arg1) {
        return holder.format("CVSSCM.NoSuchJobExists", arg1);
    }

    /**
     * No such job exists: {0}
     * 
     */
    public static Localizable _CVSSCM_NoSuchJobExists(Object arg1) {
        return new Localizable(holder, "CVSSCM.NoSuchJobExists", arg1);
    }

    /**
     * Failed to mark {0} for keep
     * 
     */
    public static String CVSSCM_FailedToMarkForKeep(Object arg1) {
        return holder.format("CVSSCM.FailedToMarkForKeep", arg1);
    }

    /**
     * Failed to mark {0} for keep
     * 
     */
    public static Localizable _CVSSCM_FailedToMarkForKeep(Object arg1) {
        return new Localizable(holder, "CVSSCM.FailedToMarkForKeep", arg1);
    }

}
