/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.cygpath;

import hudson.FilePath;
import hudson.Launcher;
import hudson.LauncherDecorator;
import hudson.Proc;
import hudson.model.Node;
import hudson.remoting.Channel;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;

public class CygpathLauncherDecorator
extends LauncherDecorator {
    public Launcher decorate(final Launcher base, Node node) {
        if (base.isUnix()) {
            return base;
        }
        return new Launcher(base){

            public boolean isUnix() {
                return base.isUnix();
            }

            public Proc launch(String[] cmd, String[] env, InputStream in, OutputStream out, FilePath workDir) throws IOException {
                return base.launch(this.cygpath(cmd), env, in, out, workDir);
            }

            public Proc launch(String[] cmd, boolean[] mask, String[] env, InputStream in, OutputStream out, FilePath workDir) throws IOException {
                return base.launch(this.cygpath(cmd), mask, env, in, out, workDir);
            }

            public Channel launchChannel(String[] cmd, OutputStream out, FilePath workDir, Map<String, String> envVars) throws IOException, InterruptedException {
                return base.launchChannel(this.cygpath(cmd), out, workDir, envVars);
            }

            public void kill(Map<String, String> modelEnvVars) throws IOException, InterruptedException {
                base.kill(modelEnvVars);
            }

            private String[] cygpath(String[] cmds) throws IOException {
                try {
                    String exe = cmds[0];
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    if (base.launch(new String[]{"cygpath", "-w", exe}, new String[0], (OutputStream)out, null).join() == 0) {
                        cmds[0] = out.toString().trim();
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                return cmds;
            }
        };
    }
}

