/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.cygpath;

import hudson.FilePath;
import hudson.Launcher;
import hudson.LauncherDecorator;
import hudson.Proc;
import hudson.model.Node;
import hudson.remoting.Callable;
import hudson.remoting.Channel;
import hudson.remoting.VirtualChannel;
import hudson.util.IOException2;
import hudson.util.jna.JnaException;
import hudson.util.jna.RegistryKey;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;

public class CygpathLauncherDecorator
extends LauncherDecorator {
    public Launcher decorate(final Launcher base, Node node) {
        if (base.isUnix()) {
            return base;
        }
        return new Launcher(base){

            public boolean isUnix() {
                return base.isUnix();
            }

            public Proc launch(Launcher.ProcStarter starter) throws IOException {
                starter = starter.copy();
                List cmds = starter.cmds();
                starter.cmds(this.cygpath(cmds.toArray(new String[cmds.size()])));
                return base.launch(starter);
            }

            public Channel launchChannel(String[] cmd, OutputStream out, FilePath workDir, Map<String, String> envVars) throws IOException, InterruptedException {
                return base.launchChannel(this.cygpath(cmd), out, workDir, envVars);
            }

            public void kill(Map<String, String> modelEnvVars) throws IOException, InterruptedException {
                base.kill(modelEnvVars);
            }

            private String[] cygpath(String[] cmds) throws IOException {
                try {
                    String cmd;
                    String exe = cmds[0];
                    if (exe.indexOf(47) < 0 && exe.indexOf(92) < 0) {
                        return cmds;
                    }
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    if (base.launch().cmds(new String[]{this.getCygpathExe(), "-w", exe}).stdout((OutputStream)out).join() == 0 && (cmd = out.toString().trim()).length() > 0) {
                        cmds[0] = cmd;
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                return cmds;
            }

            private String getCygpathExe() throws IOException, InterruptedException {
                VirtualChannel ch = base.getChannel();
                if (ch == null) {
                    return "cygpath";
                }
                return (String)ch.call((Callable)new GetCygpathTask());
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class GetCygpathTask
    implements Callable<String, IOException> {
        private GetCygpathTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private File getCygwinRoot() throws IOException {
            File file;
            RegistryKey key = RegistryKey.LOCAL_MACHINE.openReadonly("SOFTWARE\\Cygnus Solutions\\Cygwin\\mounts v2\\/");
            try {
                file = new File(key.getStringValue("native"));
            }
            catch (Throwable throwable) {
                try {
                    key.dispose();
                    throw throwable;
                }
                catch (JnaException e) {
                    throw new IOException2("Failed to locate Cygwin installation. Is Cygwin installed?", (Throwable)e);
                }
            }
            key.dispose();
            return file;
        }

        public String call() throws IOException {
            return new File(this.getCygwinRoot(), "bin\\cygpath").getPath();
        }
    }
}

