/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.view.dashboard;

import hudson.Util;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.TopLevelItem;
import hudson.model.View;
import hudson.model.ViewDescriptor;
import hudson.plugins.view.dashboard.DashboardPortlet;
import hudson.util.CaseInsensitiveComparator;
import hudson.util.FormValidation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.servlet.ServletException;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Dashboard
extends View {
    final SortedSet<String> jobNames = new TreeSet<String>(CaseInsensitiveComparator.INSTANCE);
    private String includeRegex;
    private transient Pattern includePattern;
    private List<DashboardPortlet> leftPortlets = new ArrayList<DashboardPortlet>();
    private List<DashboardPortlet> rightPortlets = new ArrayList<DashboardPortlet>();

    @DataBoundConstructor
    public Dashboard(String name) {
        super(name);
    }

    private Object readResolve() {
        if (this.includeRegex != null) {
            this.includePattern = Pattern.compile(this.includeRegex);
        }
        return this;
    }

    public String getIncludeRegex() {
        return this.includeRegex;
    }

    public List<DashboardPortlet> getLeftPortlets() {
        return this.leftPortlets;
    }

    public List<DashboardPortlet> getRightPortlets() {
        return this.rightPortlets;
    }

    public DashboardPortlet getPortlet(String name) {
        ArrayList<DashboardPortlet> allPortlets = new ArrayList<DashboardPortlet>(this.leftPortlets);
        allPortlets.addAll(this.rightPortlets);
        for (DashboardPortlet portlet : allPortlets) {
            if (!name.equals(portlet.getName())) continue;
            return portlet;
        }
        return null;
    }

    public List<Descriptor<DashboardPortlet>> getDashboardPortletDescriptors() {
        return DashboardPortlet.all();
    }

    public synchronized boolean contains(TopLevelItem item) {
        return this.jobNames.contains(item.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Item doCreateItem(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        Item item = Hudson.getInstance().doCreateItem(req, rsp);
        if (item != null) {
            Dashboard dashboard = this;
            synchronized (dashboard) {
                this.jobNames.add(item.getName());
            }
            this.owner.save();
        }
        return item;
    }

    public synchronized List<TopLevelItem> getItems() {
        TreeSet<String> names = new TreeSet<String>(this.jobNames);
        if (this.includePattern != null) {
            for (TopLevelItem item : Hudson.getInstance().getItems()) {
                String itemName = item.getName();
                if (!this.includePattern.matcher(itemName).matches()) continue;
                names.add(itemName);
            }
        }
        ArrayList<TopLevelItem> items = new ArrayList<TopLevelItem>(names.size());
        for (String n : names) {
            TopLevelItem item = Hudson.getInstance().getItem(n);
            if (item == null) continue;
            items.add(item);
        }
        return items;
    }

    public synchronized List<Job> getJobs() {
        ArrayList<Job> jobs = new ArrayList<Job>();
        for (TopLevelItem item : this.getItems()) {
            if (!(item instanceof Job)) continue;
            jobs.add((Job)item);
        }
        return jobs;
    }

    public synchronized void onJobRenamed(Item item, String oldName, String newName) {
        if (this.jobNames.remove(oldName) && newName != null) {
            this.jobNames.add(newName);
        }
    }

    protected synchronized void submit(StaplerRequest req) throws IOException, ServletException, Descriptor.FormException {
        req.setCharacterEncoding("UTF-8");
        JSONObject json = req.getSubmittedForm();
        this.jobNames.clear();
        for (TopLevelItem item : Hudson.getInstance().getItems()) {
            if (req.getParameter(item.getName()) == null) continue;
            this.jobNames.add(item.getName());
        }
        if (req.getParameter("useincluderegex") != null) {
            this.includeRegex = Util.nullify((String)req.getParameter("includeRegex"));
            this.includePattern = Pattern.compile(this.includeRegex);
        } else {
            this.includeRegex = null;
            this.includePattern = null;
        }
        this.leftPortlets = Descriptor.newInstancesFromHeteroList((StaplerRequest)req, (JSONObject)json, (String)"leftPortlet", DashboardPortlet.all());
        this.rightPortlets = Descriptor.newInstancesFromHeteroList((StaplerRequest)req, (JSONObject)json, (String)"rightPortlet", DashboardPortlet.all());
    }

    public static final class DescriptorImpl
    extends ViewDescriptor {
        public String getDisplayName() {
            return "Dashboard";
        }

        public FormValidation doCheckIncludeRegex(@QueryParameter String value) throws IOException, ServletException, InterruptedException {
            String v = Util.fixEmpty((String)value);
            if (v != null) {
                try {
                    Pattern.compile(v);
                }
                catch (PatternSyntaxException pse) {
                    return FormValidation.error((String)pse.getMessage());
                }
            }
            return FormValidation.ok();
        }
    }
}

