/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.view.dashboard.test;

import hudson.model.Job;
import hudson.model.Run;
import hudson.plugins.view.dashboard.test.TestResult;
import hudson.plugins.view.dashboard.test.TestResultSummary;
import hudson.tasks.junit.TestResultAction;
import hudson.tasks.test.AbstractTestResultAction;
import hudson.tasks.test.TestResultProjectAction;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestUtil {
    public static TestResultSummary getTestResultSummary(Collection<Job> jobs) {
        TestResultSummary summary = new TestResultSummary();
        for (Job job : jobs) {
            AbstractTestResultAction tra;
            boolean addBlank = true;
            TestResultProjectAction testResults = (TestResultProjectAction)job.getAction(TestResultProjectAction.class);
            if (testResults != null && (tra = testResults.getLastTestResultAction()) != null) {
                addBlank = false;
                summary.addTestResult(new TestResult(job, tra.getTotalCount(), tra.getFailCount(), tra.getSkipCount()));
            }
            if (!addBlank) continue;
            summary.addTestResult(new TestResult(job, 0, 0, 0));
        }
        return summary;
    }

    public static TestResult getTestResult(Run run) {
        TestResultAction tra = (TestResultAction)run.getAction(TestResultAction.class);
        if (tra != null) {
            return new TestResult(run.getParent(), tra.getTotalCount(), tra.getFailCount(), tra.getSkipCount());
        }
        return new TestResult(run.getParent(), 0, 0, 0);
    }
}

