/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.view.dashboard.builds;

import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.Job;
import hudson.model.Run;
import hudson.model.TopLevelItem;
import hudson.plugins.view.dashboard.DashboardPortlet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LatestBuilds
extends DashboardPortlet {
    private static final int N_LATEST_JOBS = 10;

    @DataBoundConstructor
    public LatestBuilds(String name) {
        super(name);
    }

    public List<Run> getFinishedBuilds() {
        List jobs = Hudson.getInstance().getItems();
        ArrayList allBuilds = new ArrayList();
        for (TopLevelItem job : jobs) {
            if (!(job instanceof Job)) continue;
            List builds = ((Job)job).getBuilds();
            allBuilds.addAll(builds);
        }
        Collections.sort(allBuilds, Run.ORDER_BY_DATE);
        List<Object> recentBuilds = new ArrayList<Run>();
        recentBuilds = allBuilds.size() < 10 ? allBuilds : allBuilds.subList(0, 10);
        return recentBuilds;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static class DescriptorImpl
    extends Descriptor<DashboardPortlet> {
        public String getDisplayName() {
            return "Last 10 jobs";
        }
    }
}

