/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.view.dashboard.stats;

import hudson.model.BallColor;
import hudson.model.Job;
import hudson.model.Run;
import hudson.model.TopLevelItem;
import hudson.plugins.view.dashboard.DashboardPortlet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatBuilds
extends DashboardPortlet {
    @DataBoundConstructor
    public StatBuilds(String name) {
        super(name);
    }

    public Map<BallColor, Integer> getBuildStat(List<TopLevelItem> jobs) {
        int nBuilds = 0;
        TreeMap<BallColor, Integer> colStatBuilds = new TreeMap<BallColor, Integer>();
        for (BallColor color : BallColor.values()) {
            colStatBuilds.put(color.noAnime(), 0);
        }
        for (TopLevelItem job : jobs) {
            if (!(job instanceof Job)) continue;
            List builds = ((Job)job).getBuilds();
            if (builds.isEmpty()) {
                colStatBuilds.put(BallColor.GREY.noAnime(), (Integer)colStatBuilds.get(BallColor.GREY) + 1);
                ++nBuilds;
                continue;
            }
            for (Run build : builds) {
                BallColor bColor = build.getIconColor();
                if (bColor == null || bColor.noAnime() == null || colStatBuilds.get(bColor) == null) continue;
                colStatBuilds.put(bColor.noAnime(), (Integer)colStatBuilds.get(bColor) + 1);
                ++nBuilds;
            }
        }
        return colStatBuilds;
    }
}

