/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.view.dashboard.test;

import hudson.model.Job;
import hudson.model.Run;
import hudson.plugins.view.dashboard.DashboardPortlet;
import hudson.plugins.view.dashboard.test.TestResult;
import hudson.plugins.view.dashboard.test.TestResultSummary;
import hudson.plugins.view.dashboard.test.TestUtil;
import hudson.util.DataSetBuilder;
import hudson.util.Graph;
import java.util.HashMap;
import java.util.Map;
import org.jfree.data.category.CategoryDataset;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePartial;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestTrendChart
extends DashboardPortlet {
    @DataBoundConstructor
    public TestTrendChart(String name) {
        super(name);
    }

    public Graph getSummaryGraph() {
        DateTime first = new DateTime();
        for (Job job : this.getDashboard().getJobs()) {
            DateTime date;
            Run firstRun = job.getFirstBuild();
            if (firstRun == null || !(date = new DateTime((Object)firstRun.getTimestamp())).isBefore((ReadableInstant)first)) continue;
            first = date;
        }
        HashMap summaries = new HashMap();
        LocalDate firstDay = new LocalDate((Object)first);
        LocalDate today = new LocalDate();
        for (Job job : this.getDashboard().getJobs()) {
            Run run = job.getFirstBuild();
            LocalDate lastRunDay = firstDay;
            while (run != null) {
                Run nextRun = run.getNextBuild();
                if (nextRun != null) {
                    LocalDate runDay = new LocalDate((Object)run.getTimestamp());
                    if (new LocalDate((Object)nextRun.getTimestamp()).isAfter((ReadablePartial)runDay)) {
                        this.summarize(summaries, run, lastRunDay, runDay);
                        lastRunDay = runDay.plusDays(1);
                    }
                } else {
                    this.summarize(summaries, run, lastRunDay, today);
                }
                run = nextRun;
            }
        }
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    private CategoryDataset buildDataSet(Map<LocalDate, TestResultSummary> summaries) {
        DataSetBuilder dsb = new DataSetBuilder();
        for (Map.Entry<LocalDate, TestResultSummary> entry : summaries.entrySet()) {
            dsb.add((Number)entry.getValue().getFailed(), (Comparable)((Object)"failed"), (Comparable)entry.getKey());
            dsb.add((Number)entry.getValue().getSkipped(), (Comparable)((Object)"skipped"), (Comparable)entry.getKey());
            dsb.add((Number)entry.getValue().getSuccess(), (Comparable)((Object)"total"), (Comparable)entry.getKey());
        }
        return dsb.build();
    }

    private void summarize(Map<LocalDate, TestResultSummary> summaries, Run run, LocalDate firstDay, LocalDate lastDay) {
        TestResult testResult = TestUtil.getTestResult((Run)run);
        LocalDate curr = firstDay;
        while (curr.compareTo((Object)lastDay) <= 0) {
            TestResultSummary trs = summaries.get(curr);
            if (trs == null) {
                trs = new TestResultSummary();
                summaries.put(curr, trs);
            }
            trs.addTestResult(testResult);
            curr = curr.plusDays(1);
        }
    }

    static /* synthetic */ CategoryDataset access$000(TestTrendChart x0, Map x1) {
        return x0.buildDataSet(x1);
    }
}

