/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.view.dashboard.test;

import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.Job;
import hudson.model.Run;
import hudson.plugins.view.dashboard.DashboardPortlet;
import hudson.plugins.view.dashboard.test.TestResult;
import hudson.plugins.view.dashboard.test.TestResultSummary;
import hudson.plugins.view.dashboard.test.TestUtil;
import hudson.util.ColorPalette;
import hudson.util.DataSetBuilder;
import hudson.util.Graph;
import hudson.util.ShiftedCategoryAxis;
import hudson.util.StackedAreaRenderer2;
import java.awt.Color;
import java.awt.Paint;
import java.util.HashMap;
import java.util.Map;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.ui.RectangleInsets;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePartial;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestTrendChart
extends DashboardPortlet {
    @DataBoundConstructor
    public TestTrendChart(String name) {
        super(name);
    }

    public Graph getSummaryGraph() {
        DateTime first = new DateTime();
        for (Job job : this.getDashboard().getJobs()) {
            DateTime date;
            Run firstRun = job.getFirstBuild();
            if (firstRun == null || !(date = new DateTime((Object)firstRun.getTimestamp())).isBefore((ReadableInstant)first)) continue;
            first = date;
        }
        final HashMap<LocalDate, TestResultSummary> summaries = new HashMap<LocalDate, TestResultSummary>();
        LocalDate firstDay = new LocalDate((Object)first);
        LocalDate today = new LocalDate();
        for (Job job : this.getDashboard().getJobs()) {
            Run run = job.getFirstBuild();
            LocalDate lastRunDay = firstDay;
            while (run != null) {
                Run nextRun = run.getNextBuild();
                if (nextRun != null) {
                    LocalDate runDay = new LocalDate((Object)run.getTimestamp());
                    if (new LocalDate((Object)nextRun.getTimestamp()).isAfter((ReadablePartial)runDay)) {
                        this.summarize(summaries, run, lastRunDay, runDay);
                        lastRunDay = runDay.plusDays(1);
                    }
                } else {
                    this.summarize(summaries, run, lastRunDay, today);
                }
                run = nextRun;
            }
        }
        return new Graph(-1L, 300, 220){

            protected JFreeChart createGraph() {
                JFreeChart chart = ChartFactory.createStackedAreaChart(null, (String)"date", (String)"count", (CategoryDataset)TestTrendChart.this.buildDataSet(summaries), (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)false, (boolean)false);
                chart.setBackgroundPaint((Paint)Color.white);
                CategoryPlot plot = chart.getCategoryPlot();
                plot.setBackgroundPaint((Paint)Color.WHITE);
                plot.setOutlinePaint(null);
                plot.setForegroundAlpha(0.8f);
                plot.setRangeGridlinesVisible(true);
                plot.setRangeGridlinePaint((Paint)Color.black);
                ShiftedCategoryAxis domainAxis = new ShiftedCategoryAxis(null);
                plot.setDomainAxis((CategoryAxis)domainAxis);
                domainAxis.setCategoryLabelPositions(CategoryLabelPositions.UP_90);
                domainAxis.setLowerMargin(0.0);
                domainAxis.setUpperMargin(0.0);
                domainAxis.setCategoryMargin(0.0);
                NumberAxis rangeAxis = (NumberAxis)plot.getRangeAxis();
                rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
                StackedAreaRenderer2 ar = new StackedAreaRenderer2();
                plot.setRenderer((CategoryItemRenderer)ar);
                ar.setSeriesPaint(0, (Paint)ColorPalette.RED);
                ar.setSeriesPaint(1, (Paint)ColorPalette.YELLOW);
                ar.setSeriesPaint(2, (Paint)ColorPalette.BLUE);
                plot.setInsets(new RectangleInsets(0.0, 0.0, 0.0, 5.0));
                return chart;
            }
        };
    }

    private CategoryDataset buildDataSet(Map<LocalDate, TestResultSummary> summaries) {
        DataSetBuilder dsb = new DataSetBuilder();
        for (Map.Entry<LocalDate, TestResultSummary> entry : summaries.entrySet()) {
            dsb.add((Number)entry.getValue().getFailed(), (Comparable)((Object)"failed"), (Comparable)entry.getKey());
            dsb.add((Number)entry.getValue().getSkipped(), (Comparable)((Object)"skipped"), (Comparable)entry.getKey());
            dsb.add((Number)entry.getValue().getSuccess(), (Comparable)((Object)"total"), (Comparable)entry.getKey());
        }
        return dsb.build();
    }

    private void summarize(Map<LocalDate, TestResultSummary> summaries, Run run, LocalDate firstDay, LocalDate lastDay) {
        TestResult testResult = TestUtil.getTestResult(run);
        LocalDate curr = firstDay;
        while (curr.compareTo((Object)lastDay) <= 0) {
            TestResultSummary trs = summaries.get(curr);
            if (trs == null) {
                trs = new TestResultSummary();
                summaries.put(curr, trs);
            }
            trs.addTestResult(testResult);
            curr = curr.plusDays(1);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static class DescriptorImpl
    extends Descriptor<DashboardPortlet> {
        public String getDisplayName() {
            return "Test Trend Chart";
        }
    }
}

