/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.view.dashboard;

import hudson.Util;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.TopLevelItem;
import hudson.model.View;
import hudson.plugins.view.dashboard.DashboardPortlet;
import hudson.util.CaseInsensitiveComparator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Dashboard
extends View {
    final SortedSet<String> jobNames = new TreeSet(CaseInsensitiveComparator.INSTANCE);
    private String includeRegex;
    private transient Pattern includePattern;
    private boolean excludeDisabledJobs = false;
    private boolean includeStdJobList = false;
    private List<DashboardPortlet> leftPortlets = new ArrayList();
    private List<DashboardPortlet> rightPortlets = new ArrayList();
    private List<DashboardPortlet> topPortlets = new ArrayList();
    private List<DashboardPortlet> bottomPortlets = new ArrayList();

    @DataBoundConstructor
    public Dashboard(String name) {
        super(name);
    }

    private Object readResolve() {
        if (this.includeRegex != null) {
            this.includePattern = Pattern.compile(this.includeRegex);
        }
        return this;
    }

    public String getIncludeRegex() {
        return this.includeRegex;
    }

    public boolean isExcludeDisabledJobs() {
        return this.excludeDisabledJobs;
    }

    public boolean isIncludeStdJobList() {
        return this.includeStdJobList;
    }

    public List<DashboardPortlet> getLeftPortlets() {
        return this.leftPortlets;
    }

    public List<DashboardPortlet> getRightPortlets() {
        return this.rightPortlets;
    }

    public List<DashboardPortlet> getTopPortlets() {
        return this.topPortlets;
    }

    public List<DashboardPortlet> getBottomPortlets() {
        return this.bottomPortlets;
    }

    public DashboardPortlet getPortlet(String name) {
        ArrayList allPortlets = new ArrayList(this.topPortlets);
        allPortlets.addAll(this.leftPortlets);
        allPortlets.addAll(this.rightPortlets);
        allPortlets.addAll(this.bottomPortlets);
        for (DashboardPortlet portlet : allPortlets) {
            if (!name.equals(portlet.getName())) continue;
            return portlet;
        }
        return null;
    }

    public List<Descriptor<DashboardPortlet>> getDashboardPortletDescriptors() {
        return DashboardPortlet.all();
    }

    public synchronized boolean contains(TopLevelItem item) {
        return this.jobNames.contains(item.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Item doCreateItem(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        Item item = Hudson.getInstance().doCreateItem(req, rsp);
        if (item != null) {
            Dashboard dashboard = this;
            synchronized (dashboard) {
                this.jobNames.add(item.getName());
            }
            this.owner.save();
        }
        return item;
    }

    public synchronized List<TopLevelItem> getItems() {
        ArrayList<TopLevelItem> items = new ArrayList<TopLevelItem>();
        List allItems = Hudson.getInstance().getItems();
        for (TopLevelItem item : allItems) {
            if (item == null || !(item instanceof Job) || !this.HasItem(item)) continue;
            items.add(item);
        }
        return items;
    }

    public synchronized boolean HasItem(TopLevelItem item) {
        if (!(item instanceof Job)) {
            return false;
        }
        boolean res = false;
        if (this.includePattern != null && this.includePattern.matcher(item.getName()).matches()) {
            res = true;
        }
        if ((res |= this.contains(item)) && this.isExcludeDisabledJobs() && item instanceof AbstractProject) {
            AbstractProject project = (AbstractProject)item;
            res &= !project.isDisabled();
        }
        return res;
    }

    public synchronized List<Job> getJobs() {
        ArrayList<Job> jobs = new ArrayList<Job>();
        for (TopLevelItem item : this.getItems()) {
            if (!(item instanceof Job)) continue;
            jobs.add((Job)item);
        }
        return jobs;
    }

    public synchronized void onJobRenamed(Item item, String oldName, String newName) {
        if (this.jobNames.remove(oldName) && newName != null) {
            this.jobNames.add(newName);
        }
    }

    protected synchronized void submit(StaplerRequest req) throws IOException, ServletException, Descriptor.FormException {
        req.setCharacterEncoding("UTF-8");
        JSONObject json = req.getSubmittedForm();
        this.jobNames.clear();
        for (TopLevelItem item : Hudson.getInstance().getItems()) {
            if (req.getParameter(item.getName()) == null) continue;
            this.jobNames.add(item.getName());
        }
        if (req.getParameter("useincluderegex") != null) {
            this.includeRegex = Util.nullify((String)req.getParameter("includeRegex"));
            this.includePattern = Pattern.compile(this.includeRegex);
        } else {
            this.includeRegex = null;
            this.includePattern = null;
        }
        String sExcludeDisabledJobs = Util.nullify((String)req.getParameter("excludeDisabledJobs"));
        this.excludeDisabledJobs = sExcludeDisabledJobs != null && "on".equals(sExcludeDisabledJobs);
        String sIncludeStdJobList = Util.nullify((String)req.getParameter("includeStdJobList"));
        this.includeStdJobList = sIncludeStdJobList != null && "on".equals(sIncludeStdJobList);
        this.leftPortlets = Descriptor.newInstancesFromHeteroList((StaplerRequest)req, (JSONObject)json, (String)"leftPortlet", (Collection)DashboardPortlet.all());
        this.rightPortlets = Descriptor.newInstancesFromHeteroList((StaplerRequest)req, (JSONObject)json, (String)"rightPortlet", (Collection)DashboardPortlet.all());
        this.topPortlets = Descriptor.newInstancesFromHeteroList((StaplerRequest)req, (JSONObject)json, (String)"topPortlet", (Collection)DashboardPortlet.all());
        this.bottomPortlets = Descriptor.newInstancesFromHeteroList((StaplerRequest)req, (JSONObject)json, (String)"bottomPortlet", (Collection)DashboardPortlet.all());
    }
}

