/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.view.dashboard;

import hudson.DescriptorExtensionList;
import hudson.Util;
import hudson.model.Descriptor;
import hudson.model.Job;
import hudson.model.ListView;
import hudson.model.TopLevelItem;
import hudson.plugins.view.dashboard.DashboardPortlet;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Dashboard
extends ListView {
    private boolean useCssStyle = false;
    private boolean includeStdJobList = false;
    private String leftPortletWidth = "50%";
    private String rightPortletWidth = "50%";
    private List<DashboardPortlet> leftPortlets = new ArrayList();
    private List<DashboardPortlet> rightPortlets = new ArrayList();
    private List<DashboardPortlet> topPortlets = new ArrayList();
    private List<DashboardPortlet> bottomPortlets = new ArrayList();

    @DataBoundConstructor
    public Dashboard(String name) {
        super(name);
    }

    public boolean isUseCssStyle() {
        return this.useCssStyle;
    }

    public boolean isIncludeStdJobList() {
        return this.includeStdJobList;
    }

    public List<DashboardPortlet> getLeftPortlets() {
        return this.leftPortlets;
    }

    public List<DashboardPortlet> getRightPortlets() {
        return this.rightPortlets;
    }

    public List<DashboardPortlet> getTopPortlets() {
        return this.topPortlets;
    }

    public List<DashboardPortlet> getBottomPortlets() {
        return this.bottomPortlets;
    }

    public String getLeftPortletWidth() {
        return this.leftPortletWidth;
    }

    public String getRightPortletWidth() {
        return this.rightPortletWidth;
    }

    public DashboardPortlet getPortlet(String name) {
        ArrayList allPortlets = new ArrayList(this.topPortlets);
        allPortlets.addAll(this.leftPortlets);
        allPortlets.addAll(this.rightPortlets);
        allPortlets.addAll(this.bottomPortlets);
        for (DashboardPortlet portlet : allPortlets) {
            if (!name.equals(portlet.getId())) continue;
            return portlet;
        }
        return null;
    }

    public DescriptorExtensionList<DashboardPortlet, Descriptor<DashboardPortlet>> getDashboardPortletDescriptors() {
        DescriptorExtensionList list = DashboardPortlet.all();
        return list;
    }

    public synchronized boolean HasItem(TopLevelItem item) {
        List items = this.getItems();
        return items.contains(item);
    }

    public synchronized List<Job> getJobs() {
        ArrayList<Job> jobs = new ArrayList<Job>();
        for (TopLevelItem item : this.getItems()) {
            if (!(item instanceof Job)) continue;
            jobs.add((Job)item);
        }
        return jobs;
    }

    protected synchronized void submit(StaplerRequest req) throws ServletException, Descriptor.FormException {
        super.submit(req);
        try {
            req.setCharacterEncoding("UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            Logger.getLogger(Dashboard.class.getName()).log(Level.SEVERE, null, ex);
        }
        JSONObject json = req.getSubmittedForm();
        String sIncludeStdJobList = Util.nullify((String)req.getParameter("includeStdJobList"));
        this.includeStdJobList = sIncludeStdJobList != null && "on".equals(sIncludeStdJobList);
        String sUseCssStyle = Util.nullify((String)req.getParameter("useCssStyle"));
        boolean bl = this.useCssStyle = sUseCssStyle != null && "on".equals(sUseCssStyle);
        if (this.useCssStyle) {
            if (req.getParameter("leftPortletWidth") != null) {
                this.leftPortletWidth = req.getParameter("leftPortletWidth");
            }
            if (req.getParameter("rightPortletWidth") != null) {
                this.rightPortletWidth = req.getParameter("rightPortletWidth");
            }
        } else {
            this.rightPortletWidth = "50%";
            this.leftPortletWidth = "50%";
        }
        this.topPortlets = Descriptor.newInstancesFromHeteroList((StaplerRequest)req, (JSONObject)json, (String)"topPortlet", (Collection)DashboardPortlet.all());
        this.leftPortlets = Descriptor.newInstancesFromHeteroList((StaplerRequest)req, (JSONObject)json, (String)"leftPortlet", (Collection)DashboardPortlet.all());
        this.rightPortlets = Descriptor.newInstancesFromHeteroList((StaplerRequest)req, (JSONObject)json, (String)"rightPortlet", (Collection)DashboardPortlet.all());
        this.bottomPortlets = Descriptor.newInstancesFromHeteroList((StaplerRequest)req, (JSONObject)json, (String)"bottomPortlet", (Collection)DashboardPortlet.all());
    }

    public void rename(String newName) throws Descriptor.FormException {
        super.rename(newName);
    }
}

