/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.view.dashboard.core;

import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.Job;
import hudson.model.Result;
import hudson.model.Run;
import hudson.plugins.view.dashboard.DashboardPortlet;
import hudson.views.JobColumn;
import hudson.views.ListViewColumn;
import hudson.views.StatusColumn;
import hudson.views.WeatherColumn;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnstableJobsPortlet
extends DashboardPortlet {
    private static final Collection<ListViewColumn> COLUMNS = Arrays.asList(new StatusColumn(), new WeatherColumn(), new JobColumn());

    @DataBoundConstructor
    public UnstableJobsPortlet(String name) {
        super(name);
    }

    public Collection<Job> getUnstableJobs(Collection<Job> allJobs) {
        ArrayList<Job> unstableJobs = new ArrayList<Job>();
        for (Job job : allJobs) {
            Run run = job.getLastCompletedBuild();
            if (run == null || !Result.UNSTABLE.isBetterOrEqualTo(run.getResult())) continue;
            unstableJobs.add(job);
        }
        return unstableJobs;
    }

    public Collection<ListViewColumn> getColumns() {
        return COLUMNS;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static class DescriptorImpl
    extends Descriptor<DashboardPortlet> {
        public String getDisplayName() {
            return "Unstable Jobs";
        }
    }
}

