/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.view.dashboard.test;

import hudson.model.Job;
import hudson.model.Run;
import hudson.plugins.view.dashboard.DashboardPortlet;
import hudson.plugins.view.dashboard.Messages;
import hudson.plugins.view.dashboard.test.TestResult;
import hudson.plugins.view.dashboard.test.TestResultSummary;
import hudson.plugins.view.dashboard.test.TestTrendChart;
import hudson.plugins.view.dashboard.test.TestUtil;
import hudson.util.DataSetBuilder;
import hudson.util.Graph;
import java.util.Map;
import java.util.TreeMap;
import org.jfree.data.category.CategoryDataset;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestTrendChart
extends DashboardPortlet {
    private int graphWidth = 300;
    private int graphHeight = 220;
    private int dateRange = 365;

    @DataBoundConstructor
    public TestTrendChart(String name, int graphWidth, int graphHeight, int dateRange) {
        super(name);
        this.graphWidth = graphWidth;
        this.graphHeight = graphHeight;
        this.dateRange = dateRange;
    }

    public int getDateRange() {
        return this.dateRange;
    }

    public int getGraphWidth() {
        return this.graphWidth <= 0 ? 300 : this.graphWidth;
    }

    public int getGraphHeight() {
        return this.graphHeight <= 0 ? 220 : this.graphHeight;
    }

    public Graph getSummaryGraph() {
        1 localDateComparator = new /* Unavailable Anonymous Inner Class!! */;
        TreeMap summaries = new TreeMap(localDateComparator);
        LocalDate today = new LocalDate();
        LocalDate firstDay = new LocalDate().minusDays(this.dateRange);
        for (Job job : this.getDashboard().getJobs()) {
            Run run = job.getFirstBuild();
            if (run == null) continue;
            LocalDate lastRunDay = new LocalDate((Object)run.getTimestamp());
            if (this.dateRange > 0 && firstDay.isAfter((ReadablePartial)lastRunDay)) {
                lastRunDay = new LocalDate().minusDays(this.dateRange);
            }
            while (run != null) {
                Run nextRun = run.getNextBuild();
                LocalDate runDay = new LocalDate((Object)run.getTimestamp());
                if (nextRun != null) {
                    if (runDay.isAfter((ReadablePartial)firstDay) && new LocalDate((Object)nextRun.getTimestamp()).isAfter((ReadablePartial)runDay)) {
                        this.summarize(summaries, run, lastRunDay, runDay);
                        lastRunDay = runDay.plusDays(1);
                    }
                } else {
                    this.summarize(summaries, run, lastRunDay, today);
                }
                run = nextRun;
            }
        }
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    private CategoryDataset buildDataSet(Map<LocalDate, TestResultSummary> summaries) {
        DataSetBuilder dsb = new DataSetBuilder();
        for (Map.Entry<LocalDate, TestResultSummary> entry : summaries.entrySet()) {
            dsb.add((Number)entry.getValue().getFailed(), (Comparable)((Object)Messages.Dashboard_Failed()), (Comparable)entry.getKey());
            dsb.add((Number)entry.getValue().getSkipped(), (Comparable)((Object)Messages.Dashboard_Skipped()), (Comparable)entry.getKey());
            dsb.add((Number)entry.getValue().getSuccess(), (Comparable)((Object)Messages.Dashboard_Total()), (Comparable)entry.getKey());
        }
        return dsb.build();
    }

    private void summarize(Map<LocalDate, TestResultSummary> summaries, Run run, LocalDate firstDay, LocalDate lastDay) {
        TestResult testResult = TestUtil.getTestResult((Run)run);
        LocalDate curr = firstDay;
        while (curr.compareTo((Object)lastDay) <= 0) {
            if (testResult.getTests() != 0) {
                TestResultSummary trs = summaries.get(curr);
                if (trs == null) {
                    trs = new TestResultSummary();
                    summaries.put(curr, trs);
                }
                trs.addTestResult(testResult);
            }
            curr = curr.plusDays(1);
        }
    }

    static /* synthetic */ CategoryDataset access$000(TestTrendChart x0, Map x1) {
        return x0.buildDataSet(x1);
    }
}

