/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.view.dashboard.builds;

import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.Job;
import hudson.model.Run;
import hudson.plugins.view.dashboard.DashboardPortlet;
import hudson.plugins.view.dashboard.Messages;
import hudson.util.RunList;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LatestBuilds
extends DashboardPortlet {
    private int numBuilds = 10;

    @DataBoundConstructor
    public LatestBuilds(String name, int numBuilds) {
        super(name);
        this.numBuilds = numBuilds;
    }

    public int getNumBuilds() {
        return this.numBuilds <= 0 ? 10 : this.numBuilds;
    }

    public String getTimestampString(Run run) {
        return DateFormat.getDateTimeInstance(2, 2).format(new Date(run.getTimeInMillis()));
    }

    public List<Run> getFinishedBuilds() {
        List<Job> jobs = this.getDashboard().getJobs();
        ArrayList allBuilds = new ArrayList();
        for (Job job : jobs) {
            RunList builds = job.getBuilds();
            allBuilds.addAll(builds);
        }
        Collections.sort(allBuilds, Run.ORDER_BY_DATE);
        List<Object> recentBuilds = new ArrayList<Run>();
        recentBuilds = allBuilds.size() < this.getNumBuilds() ? allBuilds : allBuilds.subList(0, this.getNumBuilds());
        return recentBuilds;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static class DescriptorImpl
    extends Descriptor<DashboardPortlet> {
        public String getDisplayName() {
            return Messages.Dashboard_LatestBuilds();
        }
    }
}

