/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.view.dashboard.test;

import hudson.Extension;
import hudson.model.Descriptor;
import hudson.plugins.view.dashboard.DashboardPortlet;
import hudson.plugins.view.dashboard.Messages;
import hudson.plugins.view.dashboard.test.TestResultSummary;
import hudson.plugins.view.dashboard.test.TestUtil;
import hudson.util.ColorPalette;
import hudson.util.Graph;
import java.awt.Color;
import java.awt.Paint;
import java.text.NumberFormat;
import java.util.ArrayList;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.labels.PieSectionLabelGenerator;
import org.jfree.chart.labels.StandardPieSectionLabelGenerator;
import org.jfree.chart.plot.DefaultDrawingSupplier;
import org.jfree.chart.plot.DrawingSupplier;
import org.jfree.chart.plot.PiePlot;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.general.PieDataset;
import org.kohsuke.stapler.DataBoundConstructor;

public class TestStatisticsChart
extends DashboardPortlet {
    @DataBoundConstructor
    public TestStatisticsChart(String name) {
        super(name);
    }

    public Graph getSummaryGraph() {
        final TestResultSummary summary = TestUtil.getTestResultSummary(this.getDashboard().getJobs());
        return new Graph(-1L, 300, 220){

            protected JFreeChart createGraph() {
                DefaultPieDataset dataset = new DefaultPieDataset();
                dataset.setValue((Comparable)((Object)Messages.Dashboard_Success()), (double)summary.getSuccess());
                dataset.setValue((Comparable)((Object)Messages.Dashboard_Skipped()), (double)summary.getSkipped());
                dataset.setValue((Comparable)((Object)Messages.Dashboard_Failed()), (double)summary.getFailed());
                JFreeChart chart = ChartFactory.createPieChart(null, (PieDataset)dataset, (boolean)false, (boolean)false, (boolean)false);
                chart.setBackgroundPaint((Paint)Color.white);
                PiePlot plot = (PiePlot)chart.getPlot();
                plot.setBackgroundPaint((Paint)Color.WHITE);
                plot.setOutlinePaint(null);
                plot.setForegroundAlpha(0.8f);
                ArrayList<Color> paints = new ArrayList<Color>();
                if (summary.getSuccess() > 0) {
                    paints.add(ColorPalette.BLUE);
                }
                if (summary.getSkipped() > 0) {
                    paints.add(ColorPalette.YELLOW);
                }
                if (summary.getFailed() > 0) {
                    paints.add(ColorPalette.RED);
                }
                DefaultDrawingSupplier ds = new DefaultDrawingSupplier(paints.toArray(new Paint[0]), DefaultDrawingSupplier.DEFAULT_OUTLINE_PAINT_SEQUENCE, DefaultDrawingSupplier.DEFAULT_STROKE_SEQUENCE, DefaultDrawingSupplier.DEFAULT_OUTLINE_STROKE_SEQUENCE, DefaultDrawingSupplier.DEFAULT_SHAPE_SEQUENCE);
                plot.setDrawingSupplier((DrawingSupplier)ds);
                plot.setLabelGenerator((PieSectionLabelGenerator)new StandardPieSectionLabelGenerator("{0} = {1} ({2})", NumberFormat.getNumberInstance(), NumberFormat.getPercentInstance()));
                plot.setNoDataMessage(Messages.Dashboard_NoDataAvailable());
                return chart;
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static class DescriptorImpl
    extends Descriptor<DashboardPortlet> {
        public String getDisplayName() {
            return Messages.Dashboard_TestStatisticsChart();
        }
    }
}

