/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.view.dashboard.test;

import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.Job;
import hudson.model.Run;
import hudson.plugins.view.dashboard.DashboardPortlet;
import hudson.plugins.view.dashboard.Messages;
import hudson.plugins.view.dashboard.test.TestResult;
import hudson.plugins.view.dashboard.test.TestResultSummary;
import hudson.plugins.view.dashboard.test.TestUtil;
import hudson.util.ColorPalette;
import hudson.util.DataSetBuilder;
import hudson.util.Graph;
import hudson.util.ShiftedCategoryAxis;
import hudson.util.StackedAreaRenderer2;
import java.awt.Color;
import java.awt.Paint;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.ui.RectangleInsets;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestTrendChart
extends DashboardPortlet {
    private int graphWidth = 300;
    private int graphHeight = 220;
    private int dateRange = 365;

    @DataBoundConstructor
    public TestTrendChart(String name, int graphWidth, int graphHeight, int dateRange) {
        super(name);
        this.graphWidth = graphWidth;
        this.graphHeight = graphHeight;
        this.dateRange = dateRange;
    }

    public int getDateRange() {
        return this.dateRange;
    }

    public int getGraphWidth() {
        return this.graphWidth <= 0 ? 300 : this.graphWidth;
    }

    public int getGraphHeight() {
        return this.graphHeight <= 0 ? 220 : this.graphHeight;
    }

    public Graph getSummaryGraph() {
        Comparator<LocalDate> localDateComparator = new Comparator<LocalDate>(){

            @Override
            public int compare(LocalDate d1, LocalDate d2) {
                if (d1.isEqual((ReadablePartial)d2)) {
                    return 0;
                }
                if (d1.isAfter((ReadablePartial)d2)) {
                    return 1;
                }
                return -1;
            }
        };
        final TreeMap<LocalDate, TestResultSummary> summaries = new TreeMap<LocalDate, TestResultSummary>(localDateComparator);
        LocalDate today = new LocalDate();
        LocalDate firstDay = new LocalDate().minusDays(this.dateRange);
        for (Job job : this.getDashboard().getJobs()) {
            Run run = job.getFirstBuild();
            if (run == null) continue;
            LocalDate lastRunDay = new LocalDate((Object)run.getTimestamp());
            if (this.dateRange > 0 && firstDay.isAfter((ReadablePartial)lastRunDay)) {
                lastRunDay = new LocalDate().minusDays(this.dateRange);
            }
            while (run != null) {
                Run nextRun = run.getNextBuild();
                LocalDate runDay = new LocalDate((Object)run.getTimestamp());
                if (nextRun != null) {
                    if (runDay.isAfter((ReadablePartial)firstDay) && new LocalDate((Object)nextRun.getTimestamp()).isAfter((ReadablePartial)runDay)) {
                        this.summarize(summaries, run, lastRunDay, runDay);
                        lastRunDay = runDay.plusDays(1);
                    }
                } else {
                    this.summarize(summaries, run, lastRunDay, today);
                }
                run = nextRun;
            }
        }
        return new Graph(-1L, this.getGraphWidth(), this.getGraphHeight()){

            protected JFreeChart createGraph() {
                JFreeChart chart = ChartFactory.createStackedAreaChart(null, (String)Messages.Dashboard_Date(), (String)Messages.Dashboard_Count(), (CategoryDataset)TestTrendChart.this.buildDataSet(summaries), (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)false, (boolean)false);
                chart.setBackgroundPaint((Paint)Color.white);
                CategoryPlot plot = chart.getCategoryPlot();
                plot.setBackgroundPaint((Paint)Color.WHITE);
                plot.setOutlinePaint(null);
                plot.setForegroundAlpha(0.8f);
                plot.setRangeGridlinesVisible(true);
                plot.setRangeGridlinePaint((Paint)Color.black);
                ShiftedCategoryAxis domainAxis = new ShiftedCategoryAxis(null);
                plot.setDomainAxis((CategoryAxis)domainAxis);
                domainAxis.setCategoryLabelPositions(CategoryLabelPositions.UP_90);
                domainAxis.setLowerMargin(0.0);
                domainAxis.setUpperMargin(0.0);
                domainAxis.setCategoryMargin(0.0);
                NumberAxis rangeAxis = (NumberAxis)plot.getRangeAxis();
                rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
                StackedAreaRenderer2 ar = new StackedAreaRenderer2();
                plot.setRenderer((CategoryItemRenderer)ar);
                ar.setSeriesPaint(0, (Paint)ColorPalette.RED);
                ar.setSeriesPaint(1, (Paint)ColorPalette.YELLOW);
                ar.setSeriesPaint(2, (Paint)ColorPalette.BLUE);
                plot.setInsets(new RectangleInsets(0.0, 0.0, 0.0, 5.0));
                return chart;
            }
        };
    }

    private CategoryDataset buildDataSet(Map<LocalDate, TestResultSummary> summaries) {
        DataSetBuilder dsb = new DataSetBuilder();
        for (Map.Entry<LocalDate, TestResultSummary> entry : summaries.entrySet()) {
            dsb.add((Number)entry.getValue().getFailed(), (Comparable)((Object)Messages.Dashboard_Failed()), (Comparable)entry.getKey());
            dsb.add((Number)entry.getValue().getSkipped(), (Comparable)((Object)Messages.Dashboard_Skipped()), (Comparable)entry.getKey());
            dsb.add((Number)entry.getValue().getSuccess(), (Comparable)((Object)Messages.Dashboard_Total()), (Comparable)entry.getKey());
        }
        return dsb.build();
    }

    private void summarize(Map<LocalDate, TestResultSummary> summaries, Run run, LocalDate firstDay, LocalDate lastDay) {
        TestResult testResult = TestUtil.getTestResult(run);
        LocalDate curr = firstDay;
        while (curr.compareTo((Object)lastDay) <= 0) {
            if (testResult.getTests() != 0) {
                TestResultSummary trs = summaries.get(curr);
                if (trs == null) {
                    trs = new TestResultSummary();
                    summaries.put(curr, trs);
                }
                trs.addTestResult(testResult);
            }
            curr = curr.plusDays(1);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static class DescriptorImpl
    extends Descriptor<DashboardPortlet> {
        public String getDisplayName() {
            return Messages.Dashboard_TestTrendChart();
        }
    }
}

