/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.view.dashboard.stats;

import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.HealthReport;
import hudson.model.Hudson;
import hudson.model.Job;
import hudson.model.TopLevelItem;
import hudson.plugins.view.dashboard.DashboardPortlet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatJobs
extends DashboardPortlet {
    @DataBoundConstructor
    public StatJobs(String name) {
        super(name);
    }

    public Map<HealthStatus, Integer> getJobStat(List<TopLevelItem> jobs) {
        TreeMap<HealthStatus, Integer> colStatJobs = new TreeMap<HealthStatus, Integer>();
        for (HealthStatus status : HealthStatus.values()) {
            colStatJobs.put(status, 0);
        }
        for (TopLevelItem job : jobs) {
            if (!(job instanceof Job)) continue;
            HealthStatus status = HealthStatus.getHealthStatus((Job)job);
            colStatJobs.put(status, (Integer)colStatJobs.get((Object)status) + 1);
        }
        return colStatJobs;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static class DescriptorImpl
    extends Descriptor<DashboardPortlet> {
        public String getDisplayName() {
            return "Job statistics";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum HealthStatus {
        HEALTH_OVER_80("health-80plus.gif", "No recent builds failed"),
        HEALTH_60_TO_79("health-60to79.gif", "20-40% of recent builds failed"),
        HEALTH_40_TO_59("health-40to59.gif", "40-60% of recent builds failed"),
        HEALTH_20_TO_39("health-20to39.gif", "60-80% of recent builds failed"),
        HEALTH_0_TO_19("health-00to19.gif", "All recent builds failed"),
        HEALTH_UNKNOWN("empty.gif", "Unknown status");

        private HealthReport healthReport;
        private String iconUrl;
        private String description;

        private HealthStatus(String iconUrl, String description) {
            this.iconUrl = iconUrl;
            this.description = description;
        }

        public static HealthStatus getHealthStatus(Job job) {
            int score = job.getBuildHealth().getScore();
            int nBuilds = job.getBuilds().size();
            if (score < 20) {
                return HEALTH_0_TO_19;
            }
            if (score < 40) {
                return HEALTH_20_TO_39;
            }
            if (score < 60) {
                return HEALTH_40_TO_59;
            }
            if (score < 80) {
                return HEALTH_60_TO_79;
            }
            if (score >= 79) {
                if (nBuilds != 0) {
                    return HEALTH_OVER_80;
                }
                return HEALTH_UNKNOWN;
            }
            return HEALTH_UNKNOWN;
        }

        public String getIconUrl() {
            return Hudson.RESOURCE_PATH + "/images/32x32/" + this.iconUrl;
        }

        public String getIconUrl(String size) {
            if (this.iconUrl == null) {
                return Hudson.RESOURCE_PATH + "/images/" + size + "/" + HEALTH_UNKNOWN.getIconUrl();
            }
            if (this.iconUrl.startsWith("/")) {
                return this.iconUrl.replace("/32x32/", "/" + size + "/");
            }
            return Hudson.RESOURCE_PATH + "/images/" + size + "/" + this.iconUrl;
        }

        public String getDescription() {
            return this.description;
        }
    }
}

