/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.dbcharts;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JDBCConnection
implements Serializable {
    private static final long serialVersionUID = -7258724749798334055L;
    public final String name;
    public final String url;
    public final String user;
    public final String passwd;

    @DataBoundConstructor
    public JDBCConnection(String name, String url, String user, String passwd) {
        this.name = name;
        this.url = url;
        this.user = user;
        this.passwd = passwd;
    }

    public JDBCConnection(JSONObject o) {
        this.name = o.getString("name");
        this.url = o.getString("url");
        this.user = o.getString("user");
        this.passwd = o.getString("passwd");
    }

    public List<String> getDrivers() {
        Enumeration<Driver> e = DriverManager.getDrivers();
        LinkedList<String> res = new LinkedList<String>();
        while (e.hasMoreElements()) {
            res.add(e.nextElement().getClass().getCanonicalName());
        }
        return res;
    }

    public abstract String getDriver();

    public Connection createConnection() throws SQLException {
        return DriverManager.getConnection(this.url, this.user, this.passwd);
    }
}

