/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.dbcharts;

import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.plugins.dbcharts.Chart;
import hudson.plugins.dbcharts.CustomJDBCConnection;
import hudson.plugins.dbcharts.DbChartAction;
import hudson.plugins.dbcharts.JDBCConnection;
import hudson.plugins.dbcharts.MySQLJDBCConnection;
import hudson.plugins.dbcharts.PostgresqlJDBCConnection;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import hudson.util.FormValidation;
import java.io.IOException;
import java.sql.Driver;
import java.sql.DriverManager;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DbChartPublisher
extends Recorder {
    static final Logger logger = Logger.getLogger(DbChartPublisher.class.getCanonicalName());
    private final List<Chart> charts;

    public DbChartPublisher() {
        this.charts = new LinkedList<Chart>();
    }

    @DataBoundConstructor
    public DbChartPublisher(List<Chart> charts) {
        this.charts = charts;
    }

    public List<Chart> getCharts() {
        return this.charts;
    }

    public Action getProjectAction(AbstractProject project) {
        logger.info("DbChartPublisher.getProjectAction called");
        return new DbChartAction(project, this);
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public DescriptorImpl getDescriptor() {
        logger.info("DbChartPublisher.getDescriptor() called");
        return (DescriptorImpl)super.getDescriptor();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        private static final Logger logger = Logger.getLogger(DescriptorImpl.class.getCanonicalName());
        public List<JDBCConnection> connections;

        public DescriptorImpl() {
            logger.fine("DescriptorImpl constructed");
            this.load();
        }

        public List<JDBCConnection> getConnections() {
            return this.connections;
        }

        public List<String> getDrivers() {
            Enumeration<Driver> e = DriverManager.getDrivers();
            LinkedList<String> res = new LinkedList<String>();
            while (e.hasMoreElements()) {
                res.add(e.nextElement().getClass().getCanonicalName());
            }
            logger.fine("DescriptorImpl.getDrivers returned:" + Arrays.toString(res.toArray()));
            return res;
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public String getDisplayName() {
            return "dbCharts configuration";
        }

        public boolean configure(StaplerRequest req, JSONObject json) throws Descriptor.FormException {
            logger.fine("DescriptorImpl.configure:" + json);
            this.connections = new LinkedList<JDBCConnection>();
            Object ob = json.get("connections");
            try {
                if (ob instanceof JSONArray) {
                    for (Object o : (JSONArray)ob) {
                        JDBCConnection c = (JDBCConnection)Class.forName(((JSONObject)o).getString("stapler-class")).getConstructor(JSONObject.class).newInstance(o);
                        this.connections.add(c);
                    }
                } else if (ob != null) {
                    JDBCConnection c = (JDBCConnection)Class.forName(((JSONObject)ob).getString("stapler-class")).getConstructor(JSONObject.class).newInstance(ob);
                    this.connections.add(c);
                }
            }
            catch (Exception e) {
                throw new Descriptor.FormException("Failed to save dbCharts connections", (Throwable)e, "connections");
            }
            this.save();
            return super.configure(req, json);
        }

        public FormValidation doCheckName(@QueryParameter String value) throws IOException, ServletException {
            if (value.length() == 0) {
                return FormValidation.error((String)"Please set a name");
            }
            if (value.length() < 4) {
                return FormValidation.warning((String)"Isn't the name too short?");
            }
            return FormValidation.ok();
        }

        public List<Descriptor> getJDBCConnectionDescriptors() {
            LinkedList<Descriptor> res = new LinkedList<Descriptor>();
            Descriptor custom = Hudson.getInstance().getDescriptorByType(CustomJDBCConnection.CustomJDBCConnectionDescriptor.class);
            Descriptor mysql = Hudson.getInstance().getDescriptorByType(MySQLJDBCConnection.MySQLJDBCConnectionDescriptor.class);
            Descriptor pgsql = Hudson.getInstance().getDescriptorByType(PostgresqlJDBCConnection.PostgresqlJDBCConnectionDescriptor.class);
            res.add(mysql);
            res.add(pgsql);
            res.add(custom);
            logger.fine("getJDBCConnectionDescriptors(): custom=" + custom + "; mysql=" + mysql);
            return res;
        }
    }
}

