/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.dependencyanalyzer;

import hudson.maven.MavenBuild;
import hudson.maven.MavenModule;
import hudson.maven.MavenModuleSetBuild;
import hudson.plugins.dependencyanalyzer.parser.BuildLogFileParser;
import hudson.plugins.dependencyanalyzer.parser.DependencyAnalysisParser;
import hudson.plugins.dependencyanalyzer.result.BuildResult;
import hudson.plugins.dependencyanalyzer.result.ModuleResult;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class DependencyAnalyzerResultBuilder {
    public static final Logger LOGGER = Logger.getLogger(DependencyAnalyzerResultBuilder.class.toString());

    public static BuildResult buildResult(MavenModuleSetBuild build) throws IOException {
        Map moduleBuilds = build.getModuleBuilds();
        Iterator iterator = moduleBuilds.keySet().iterator();
        BuildResult analysisResult = new BuildResult();
        while (iterator.hasNext()) {
            List builds = (List)moduleBuilds.get(iterator.next());
            MavenBuild moduleBuild = (MavenBuild)builds.get(0);
            File logFile = moduleBuild.getLogFile();
            MavenModule mavenModule = (MavenModule)moduleBuild.getProject();
            ModuleResult moduleResult = DependencyAnalyzerResultBuilder.buildModuleResult((MavenModule)mavenModule, (File)logFile);
            analysisResult.addResult(moduleResult);
        }
        return analysisResult;
    }

    private static ModuleResult buildModuleResult(MavenModule module, File logFile) throws IOException {
        ModuleResult moduleResult = new ModuleResult();
        BuildLogFileParser logFileParser = new BuildLogFileParser();
        logFileParser.parseLogFile(logFile);
        String dependencySection = logFileParser.getDependencyAnalyseBlock();
        if (StringUtils.isBlank((String)dependencySection)) {
            LOGGER.info("No dependency section found. Add dependency:analyze on your job configuration.");
            return moduleResult;
        }
        Map dependencyProblems = DependencyAnalysisParser.parseDependencyAnalyzeSection((String)dependencySection);
        moduleResult.setModuleName(module.getModuleName());
        moduleResult.setDisplayName(module.getDisplayName());
        moduleResult.setDependencyProblems(dependencyProblems);
        return moduleResult;
    }
}

