/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.dependencyanalyzer.parser;

import hudson.plugins.dependencyanalyzer.result.DependencyProblemType;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DependencyAnalysisParser {
    private static final Pattern ARTIFACT_PATTERN = Pattern.compile(".*:.*:.*:.*:.*");

    public static Map<DependencyProblemType, List<String>> parseDependencyAnalyzeSection(String content) throws IOException {
        HashMap<DependencyProblemType, List<String>> result = new HashMap<DependencyProblemType, List<String>>();
        List lines = IOUtils.readLines((Reader)new StringReader(content));
        DependencyProblemType currentProblemType = null;
        for (String line : lines) {
            if (StringUtils.isBlank((String)line)) continue;
            DependencyProblemType problemType = DependencyProblemTypesDetection.matchAny(line);
            if (problemType != null) {
                currentProblemType = problemType;
                continue;
            }
            if (currentProblemType == null || !ARTIFACT_PATTERN.matcher(line).matches()) continue;
            ArrayList<String> problems = (ArrayList<String>)result.get((Object)currentProblemType);
            if (problems == null) {
                problems = new ArrayList<String>();
                result.put(currentProblemType, problems);
            }
            problems.add(line.substring(line.lastIndexOf(93) + 1).trim());
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DependencyProblemTypesDetection {
        UNUSED(DependencyProblemType.UNUSED, ".*Unused declared.*"),
        UNDECLARED(DependencyProblemType.UNDECLARED, ".*Used undeclared.*");

        private Pattern pattern;
        private DependencyProblemType problemType;

        private DependencyProblemTypesDetection(DependencyProblemType problemType, String regex) {
            this.problemType = problemType;
            this.pattern = Pattern.compile(regex);
        }

        private DependencyProblemType getProblemType() {
            return this.problemType;
        }

        public static DependencyProblemType matchAny(String line) {
            for (DependencyProblemTypesDetection problem : DependencyProblemTypesDetection.values()) {
                if (!problem.pattern.matcher(line).matches()) continue;
                return problem.getProblemType();
            }
            return null;
        }
    }
}

