/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.dependencyanalyzer;

import hudson.model.AbstractBuild;
import hudson.model.Action;
import hudson.plugins.dependencyanalyzer.Messages;
import hudson.plugins.dependencyanalyzer.persistence.BuildResultSerializer;
import hudson.plugins.dependencyanalyzer.result.BuildResult;
import java.io.File;
import java.io.IOException;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DependencyAnalyzerPublisherAction
implements Action {
    private static final Logger LOGGER = Logger.getLogger(DependencyAnalyzerPublisherAction.class.getName());
    private AbstractBuild<?, ?> build;
    private transient BuildResult analysis;

    public DependencyAnalyzerPublisherAction() {
    }

    public DependencyAnalyzerPublisherAction(AbstractBuild<?, ?> build, BuildResult analysis) {
        this.build = build;
        this.analysis = analysis;
    }

    public String getDisplayName() {
        return Messages.dependencyanalyzer_name();
    }

    public String getIconFileName() {
        return "/plugin/dependencyanalyzer/img/dependency.png";
    }

    public String getUrlName() {
        return "dependencyanalyzer";
    }

    public AbstractBuild<?, ?> getBuild() {
        return this.build;
    }

    public BuildResult getBuildResult() {
        if (this.analysis == null) {
            try {
                this.analysis = BuildResultSerializer.deserialize((File)this.build.getRootDir());
            }
            catch (IOException e) {
                LOGGER.severe("Error getting result from disk");
            }
        }
        return this.analysis;
    }
}

