/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.dependencyanalyzer;

import hudson.Launcher;
import hudson.maven.MavenModuleSetBuild;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Result;
import hudson.plugins.dependencyanalyzer.DependencyAnalyzerPublisherAction;
import hudson.plugins.dependencyanalyzer.DependencyAnalyzerPublisherDescriptor;
import hudson.plugins.dependencyanalyzer.DependencyAnalyzerResultBuilder;
import hudson.plugins.dependencyanalyzer.persistence.BuildResultSerializer;
import hudson.plugins.dependencyanalyzer.result.BuildResult;
import hudson.tasks.Publisher;
import java.io.IOException;
import java.util.logging.Logger;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DependencyAnalyzerPublisher
extends Publisher {
    public static final Logger LOGGER = Logger.getLogger(DependencyAnalyzerPublisher.class.getName());
    public static final Descriptor<Publisher> DESCRIPTOR = new DependencyAnalyzerPublisherDescriptor();

    @DataBoundConstructor
    public DependencyAnalyzerPublisher() {
    }

    public Descriptor<Publisher> getDescriptor() {
        return DESCRIPTOR;
    }

    public boolean perform(AbstractBuild build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        Result result = build.getResult();
        if (!Result.SUCCESS.equals(result) && !Result.UNSTABLE.equals(result)) {
            LOGGER.info("Build is not successful, no dependency analysis.");
            return false;
        }
        BuildResult analysis = DependencyAnalyzerResultBuilder.buildResult((MavenModuleSetBuild)build);
        BuildResultSerializer.serialize(build.getRootDir(), analysis);
        build.getActions().add(new DependencyAnalyzerPublisherAction(build, analysis));
        return super.perform(build, launcher, listener);
    }
}

