/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.dependencyanalyzer.parser;

import hudson.plugins.dependencyanalyzer.parser.BuildLogFileParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class BuildLogFileParser {
    public static final Logger LOGGER = Logger.getLogger(BuildLogFileParser.class.getName());
    private static final String LOG_LEVEL_REGEX = "^\\[(INFO|WARNING)\\] ";
    private static final Pattern GOAL_START = Pattern.compile("^\\[(INFO|WARNING)\\] \\[.*:.*\\]$");
    private static final Pattern END_OF_BUILD = Pattern.compile("^\\[(INFO|WARNING)\\] [-]*$");
    private static final Pattern MAVEN_OUTPUT = Pattern.compile("^\\[(INFO|WARNING)\\] .*");
    private boolean parsed = false;
    private Map<Goal, String> goalsLog = new HashMap();

    public void parseLogFile(File logFile) throws IOException {
        LOGGER.fine("Parsing " + logFile.getAbsolutePath());
        FileInputStream input = new FileInputStream(logFile);
        List lines = IOUtils.readLines((InputStream)input);
        Iterator lineIterator = lines.iterator();
        while (lineIterator.hasNext()) {
            String line = (String)lineIterator.next();
            Goal goal = Goal.getMatchingGoal((String)line);
            if (goal == null) continue;
            StringBuilder section = new StringBuilder();
            while (lineIterator.hasNext() && !this.parsed) {
                line = (String)lineIterator.next();
                if (GOAL_START.matcher(line).matches() || END_OF_BUILD.matcher(line).matches()) {
                    this.parsed = true;
                    continue;
                }
                if (!MAVEN_OUTPUT.matcher(line).matches()) continue;
                section.append(line).append("\n");
            }
            this.goalsLog.put(goal, section.toString());
        }
        this.parsed = true;
    }

    private String getContent(Goal goal) {
        if (!this.parsed) {
            throw new RuntimeException("No log file was parsed");
        }
        return (String)this.goalsLog.get(goal);
    }

    public String getDependencyAnalyseBlock() {
        return this.getContent(Goal.DEPENDENCY_ANALYSE);
    }
}

