/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.deploy;

import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Result;
import hudson.plugins.deploy.ContainerAdapter;
import hudson.plugins.deploy.Messages;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Publisher;
import hudson.util.DescriptorList;
import java.io.IOException;
import java.io.Serializable;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeployPublisher
extends Publisher
implements Serializable {
    public final ContainerAdapter adapter;
    public final String war;
    private static final long serialVersionUID = 1L;

    public DeployPublisher(ContainerAdapter adapter, String war) {
        this.adapter = adapter;
        this.war = war;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        FilePath warFile = ((AbstractProject)build.getParent()).getWorkspace().child(this.war);
        if (!this.adapter.redeploy(warFile, build, launcher, listener)) {
            build.setResult(Result.FAILURE);
        }
        return true;
    }

    public DescriptorImpl getDescriptor() {
        return DescriptorImpl.INSTANCE;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public static final DescriptorImpl INSTANCE = new DescriptorImpl();

        private DescriptorImpl() {
            super(DeployPublisher.class);
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public Publisher newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            return new DeployPublisher((ContainerAdapter)ContainerAdapter.LIST.newInstanceFromRadioList(formData), formData.getString("war"));
        }

        public String getDisplayName() {
            return Messages.DeployPublisher_DisplayName();
        }

        public DescriptorList<ContainerAdapter> getContainerAdapters() {
            return ContainerAdapter.LIST;
        }
    }
}

