/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.deploy;

import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Result;
import hudson.plugins.deploy.ContainerAdapter;
import hudson.plugins.deploy.DeployPublisher;
import hudson.tasks.Publisher;
import java.io.IOException;
import java.io.Serializable;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeployPublisher
extends Publisher
implements Serializable {
    public final ContainerAdapter adapter;
    public final String war;
    private static final long serialVersionUID = 1L;

    @DataBoundConstructor
    public DeployPublisher(ContainerAdapter adapter, String war) {
        this.adapter = adapter;
        this.war = war;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        FilePath warFile = ((AbstractProject)build.getParent()).getWorkspace().child(this.war);
        if (!this.adapter.redeploy(warFile, build, launcher, listener)) {
            build.setResult(Result.FAILURE);
        }
        return true;
    }

    public DescriptorImpl getDescriptor() {
        return DescriptorImpl.INSTANCE;
    }
}

