/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.deploy;

import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.plugins.deploy.ContainerAdapter;
import hudson.plugins.deploy.LoggerImpl;
import hudson.plugins.deploy.Messages;
import hudson.remoting.VirtualChannel;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import org.codehaus.cargo.container.Container;
import org.codehaus.cargo.container.ContainerType;
import org.codehaus.cargo.container.configuration.Configuration;
import org.codehaus.cargo.container.configuration.ConfigurationType;
import org.codehaus.cargo.container.deployable.Deployable;
import org.codehaus.cargo.container.deployable.WAR;
import org.codehaus.cargo.container.deployer.Deployer;
import org.codehaus.cargo.generic.DefaultContainerFactory;
import org.codehaus.cargo.generic.configuration.DefaultConfigurationFactory;
import org.codehaus.cargo.generic.deployer.DefaultDeployerFactory;
import org.codehaus.cargo.util.log.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CargoContainerAdapter
implements ContainerAdapter,
Serializable {
    protected abstract String getContainerId();

    protected abstract void configure(Configuration var1);

    @Override
    public boolean redeploy(FilePath war, AbstractBuild<?, ?> build, Launcher launcher, final BuildListener listener) throws IOException, InterruptedException {
        return (Boolean)war.act((FilePath.FileCallable)new FilePath.FileCallable<Boolean>(){

            public Boolean invoke(File f, VirtualChannel channel) throws IOException {
                if (!f.exists()) {
                    listener.error(Messages.DeployPublisher_NoSuchFile(f));
                    return true;
                }
                DefaultConfigurationFactory configFactory = new DefaultConfigurationFactory();
                DefaultContainerFactory containerFactory = new DefaultContainerFactory();
                DefaultDeployerFactory deployerFactory = new DefaultDeployerFactory();
                String id = CargoContainerAdapter.this.getContainerId();
                Configuration config = configFactory.createConfiguration(id, ContainerType.REMOTE, ConfigurationType.RUNTIME);
                CargoContainerAdapter.this.configure(config);
                Container container = containerFactory.createContainer(id, ContainerType.REMOTE, config);
                Deployer deployer = deployerFactory.createDeployer(container);
                listener.getLogger().println("Deploying " + f);
                deployer.setLogger((Logger)new LoggerImpl(listener.getLogger()));
                deployer.redeploy((Deployable)new WAR(f.getAbsolutePath()));
                return true;
            }
        });
    }
}

