/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.deploy;

import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Result;
import hudson.plugins.deploy.ContainerAdapter;
import hudson.plugins.deploy.ContainerAdapterDescriptor;
import hudson.plugins.deploy.Messages;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Notifier;
import hudson.tasks.Publisher;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeployPublisher
extends Notifier
implements Serializable {
    public final ContainerAdapter adapter;
    public final String war;
    public final boolean onFailure;
    private static final long serialVersionUID = 1L;

    @DataBoundConstructor
    public DeployPublisher(ContainerAdapter adapter, String war, boolean onFailure) {
        this.adapter = adapter;
        this.war = war;
        this.onFailure = onFailure;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        if (build.getResult().equals(Result.SUCCESS) || this.onFailure) {
            for (FilePath warFile : build.getWorkspace().list(this.war)) {
                if (this.adapter.redeploy(warFile, build, launcher, listener)) continue;
                build.setResult(Result.FAILURE);
            }
        }
        return true;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.BUILD;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public String getDisplayName() {
            return Messages.DeployPublisher_DisplayName();
        }

        public List<ContainerAdapterDescriptor> getContainerAdapters() {
            ArrayList<ContainerAdapterDescriptor> r = new ArrayList<ContainerAdapterDescriptor>((Collection<ContainerAdapterDescriptor>)ContainerAdapter.all());
            Collections.sort(r, new Comparator<ContainerAdapterDescriptor>(){

                @Override
                public int compare(ContainerAdapterDescriptor o1, ContainerAdapterDescriptor o2) {
                    return o1.getDisplayName().compareTo(o2.getDisplayName());
                }
            });
            return r;
        }
    }
}

