/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.deploy;

import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Result;
import hudson.plugins.deploy.ContainerAdapter;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Notifier;
import java.io.IOException;
import java.io.Serializable;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeployPublisher
extends Notifier
implements Serializable {
    public final ContainerAdapter adapter;
    public final String war;
    public final boolean onFailure;
    private static final long serialVersionUID = 1L;

    @DataBoundConstructor
    public DeployPublisher(ContainerAdapter adapter, String war, boolean onFailure) {
        this.adapter = adapter;
        this.war = war;
        this.onFailure = onFailure;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        if (build.getResult().equals(Result.SUCCESS) || this.onFailure) {
            for (FilePath warFile : build.getWorkspace().list(this.war)) {
                if (this.adapter.redeploy(warFile, build, launcher, listener)) continue;
                build.setResult(Result.FAILURE);
            }
        }
        return true;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.BUILD;
    }
}

