/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.descriptionsetter;

import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Result;
import hudson.plugins.descriptionsetter.DescriptionSetterAction;
import hudson.plugins.descriptionsetter.DescriptionSetterPublisher;
import hudson.tasks.Publisher;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DescriptionSetterPublisher
extends Publisher {
    private final boolean explicitNotRegexp;
    private final String regexp;
    private final boolean setForFailed;
    private final String regexpForFailed;

    @DataBoundConstructor
    public DescriptionSetterPublisher(boolean explicitNotRegexp, String regexp, boolean setForFailed, String regexpForFailed) {
        this.explicitNotRegexp = explicitNotRegexp;
        this.regexp = regexp;
        this.setForFailed = setForFailed;
        this.regexpForFailed = regexpForFailed;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException {
        try {
            if (!this.explicitNotRegexp) {
                if (this.setForFailed && build.getResult().isWorseThan(Result.UNSTABLE)) {
                    String description = null;
                    if (this.regexpForFailed != null && !this.regexpForFailed.equals("")) {
                        description = this.parseFailLog(build.getLogFile());
                    }
                    if (description == null) {
                        description = this.parseLog(build.getLogFile());
                    }
                    if (description != null) {
                        build.addAction((Action)new DescriptionSetterAction(description));
                        listener.getLogger().println("Description found: " + description);
                    } else {
                        listener.getLogger().println("Description not found.");
                    }
                    build.setDescription(description);
                } else if (this.setForFailed || build.getResult().isBetterOrEqualTo(Result.UNSTABLE)) {
                    String description = this.parseLog(build.getLogFile());
                    if (description != null) {
                        build.addAction((Action)new DescriptionSetterAction(description));
                        listener.getLogger().println("Description found: " + description);
                    } else {
                        listener.getLogger().println("Description not found.");
                    }
                    build.setDescription(description);
                }
            } else if (this.setForFailed && build.getResult().isWorseThan(Result.UNSTABLE)) {
                build.setDescription(this.regexpForFailed);
            } else if (this.setForFailed || build.getResult().isBetterOrEqualTo(Result.UNSTABLE)) {
                build.setDescription(this.regexp);
            }
        }
        catch (IOException e) {
            listener.getLogger().println("Description Setter: " + e.getMessage());
            e.printStackTrace(listener.getLogger());
        }
        return true;
    }

    private String parseLog(File logFile) throws IOException, InterruptedException {
        String line;
        Pattern pattern = Pattern.compile(this.regexp);
        BufferedReader reader = new BufferedReader(new FileReader(logFile));
        while ((line = reader.readLine()) != null) {
            Matcher matcher = pattern.matcher(line);
            if (!matcher.find()) continue;
            String version = matcher.groupCount() == 0 ? matcher.group() : matcher.group(1);
            return version;
        }
        return null;
    }

    private String parseFailLog(File logFile) throws IOException, InterruptedException {
        String line;
        Pattern pattern = Pattern.compile(this.regexpForFailed);
        BufferedReader reader = new BufferedReader(new FileReader(logFile));
        while ((line = reader.readLine()) != null) {
            Matcher matcher = pattern.matcher(line);
            if (!matcher.find()) continue;
            String version = matcher.groupCount() == 0 ? matcher.group() : matcher.group(1);
            return version;
        }
        return null;
    }

    public Descriptor<Publisher> getDescriptor() {
        return DescriptorImpl.INSTANCE;
    }

    public boolean isExplicitNotRegexp() {
        return this.explicitNotRegexp;
    }

    public String getRegexp() {
        return this.regexp;
    }

    public boolean isSetForFailed() {
        return this.setForFailed;
    }

    public String getRegexpForFailed() {
        return this.regexpForFailed;
    }
}

