/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.descriptionsetter;

import hudson.Launcher;
import hudson.Util;
import hudson.matrix.MatrixAggregatable;
import hudson.matrix.MatrixAggregator;
import hudson.matrix.MatrixBuild;
import hudson.model.AbstractBuild;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.plugins.descriptionsetter.DescriptionSetterAction;
import hudson.plugins.descriptionsetter.DescriptionSetterPublisher;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Recorder;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.ObjectStreamException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DescriptionSetterPublisher
extends Recorder
implements MatrixAggregatable {
    private final String regexp;
    private final String regexpForFailed;
    private final String description;
    private final String descriptionForFailed;
    private final boolean setForMatrix;
    @Deprecated
    private transient boolean setForFailed = false;
    @Deprecated
    private transient boolean explicitNotRegexp = false;

    @DataBoundConstructor
    public DescriptionSetterPublisher(String regexp, String regexpForFailed, String description, String descriptionForFailed, boolean setForMatrix) {
        this.regexp = regexp;
        this.regexpForFailed = regexpForFailed;
        this.description = Util.fixEmptyAndTrim((String)description);
        this.descriptionForFailed = Util.fixEmptyAndTrim((String)descriptionForFailed);
        this.setForMatrix = setForMatrix;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException {
        try {
            String result = null;
            boolean useUnstable = (this.regexpForFailed != null || this.descriptionForFailed != null) && build.getResult().isWorseThan(Result.UNSTABLE);
            Matcher matcher = this.parseLog(build.getLogFile(), useUnstable ? this.regexpForFailed : this.regexp);
            if (matcher != null) {
                result = this.getExpandedDescription(matcher, useUnstable ? this.descriptionForFailed : this.description);
                result = build.getEnvironment((TaskListener)listener).expand(result);
            } else if (useUnstable) {
                if (result == null && this.regexpForFailed == null && this.descriptionForFailed != null) {
                    result = this.descriptionForFailed;
                }
            } else if (result == null && this.regexp == null && this.description != null) {
                result = this.description;
            }
            if (result == null) {
                listener.getLogger().println("[description-setter] Could not determine description.");
                return true;
            }
            result = this.urlify(result);
            build.addAction((Action)new DescriptionSetterAction(result));
            listener.getLogger().println("Description set: " + result);
            build.setDescription(result);
        }
        catch (IOException e) {
            e.printStackTrace(listener.error("error while parsing logs for description-setter"));
        }
        return true;
    }

    private Matcher parseLog(File logFile, String regexp) throws IOException, InterruptedException {
        String line;
        if (regexp == null) {
            return null;
        }
        Pattern pattern = Pattern.compile(regexp);
        BufferedReader reader = new BufferedReader(new FileReader(logFile));
        while ((line = reader.readLine()) != null) {
            Matcher matcher = pattern.matcher(line);
            if (!matcher.find()) continue;
            return matcher;
        }
        return null;
    }

    private Object readResolve() throws ObjectStreamException {
        if (this.explicitNotRegexp) {
            return new DescriptionSetterPublisher(null, null, this.regexp, this.setForFailed ? this.regexpForFailed : null, false);
        }
        return this;
    }

    private String getExpandedDescription(Matcher matcher, String description) {
        String result = description;
        if (result == null) {
            result = matcher.groupCount() == 0 ? "\\0" : "\\1";
        }
        for (int i = matcher.groupCount(); i >= matcher.groupCount(); --i) {
            result = result.replace("\\" + i, matcher.group(i));
        }
        return result;
    }

    private String urlify(String text) {
        try {
            new URL(text);
            return String.format("<a href=\"%s\">%s</a>", text, text);
        }
        catch (MalformedURLException e) {
            return text;
        }
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    @Deprecated
    public boolean isExplicitNotRegexp() {
        return this.explicitNotRegexp;
    }

    public String getRegexp() {
        return this.regexp;
    }

    @Deprecated
    public boolean isSetForFailed() {
        return this.setForFailed;
    }

    public String getRegexpForFailed() {
        return this.regexpForFailed;
    }

    public String getDescription() {
        return this.description;
    }

    public String getDescriptionForFailed() {
        return this.descriptionForFailed;
    }

    public MatrixAggregator createAggregator(MatrixBuild build, Launcher launcher, BuildListener listener) {
        if (!this.isSetForMatrix()) {
            return null;
        }
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public boolean isSetForMatrix() {
        return this.setForMatrix;
    }
}

