/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.dimensionsscm;

import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.plugins.dimensionsscm.CheckInAPITask;
import hudson.plugins.dimensionsscm.CheckInCmdTask;
import hudson.plugins.dimensionsscm.DimensionsAPI;
import hudson.plugins.dimensionsscm.DimensionsSCM;
import hudson.plugins.dimensionsscm.Logger;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Notifier;
import hudson.tasks.Publisher;
import hudson.util.VariableResolver;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.Vector;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArtifactUploader
extends Notifier
implements Serializable {
    private String[] patterns = new String[0];
    private boolean forceCheckIn = false;
    private boolean forceTip = false;
    private String owningPart = null;

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    @DataBoundConstructor
    public ArtifactUploader(String[] patterns, boolean fTip, boolean fMerge, String part) {
        if (patterns != null) {
            Logger.Debug("patterns are populated");
            Vector<String> x = new Vector<String>();
            for (int t = 0; t < patterns.length; ++t) {
                if (!StringUtils.isNotEmpty((String)patterns[t])) continue;
                x.add(patterns[t]);
            }
            this.patterns = x.toArray(new String[1]);
        } else {
            this.patterns[0] = ".*";
        }
        this.forceCheckIn = fTip;
        this.forceTip = fMerge;
        this.owningPart = part;
    }

    public String[] getPatterns() {
        return this.patterns;
    }

    public String getOwningPart() {
        return this.owningPart;
    }

    public boolean isForceCheckIn() {
        return this.forceCheckIn;
    }

    public boolean isForceTip() {
        return this.forceTip;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        long key = -1L;
        Logger.Debug("Invoking perform callout " + this.getClass().getName());
        FilePath workspace = build.getWorkspace();
        boolean bRet = false;
        boolean isStream = false;
        try {
            if (!(build.getProject().getScm() instanceof DimensionsSCM)) {
                listener.fatalError("[DIMENSIONS] This plugin only works with the Dimensions SCM engine.");
                build.setResult(Result.FAILURE);
                throw new IOException("[DIMENSIONS] This plugin only works with a Dimensions SCM engine");
            }
            if (build.getResult() == Result.SUCCESS) {
                DimensionsSCM scm = (DimensionsSCM)build.getProject().getScm();
                DimensionsAPI dmSCM = new DimensionsAPI();
                String nodeName = build.getBuiltOn().getNodeName();
                Logger.Debug("Calculating version of Dimensions...");
                int version = 2009;
                key = dmSCM.login(scm.getJobUserName(), scm.getJobPasswd(), scm.getJobDatabase(), scm.getJobServer());
                if (key > 0L) {
                    Logger.Debug("Login worked.");
                    version = dmSCM.getDmVersion();
                    if (version == 0) {
                        version = 2009;
                    }
                    if (version != 10) {
                        isStream = dmSCM.isStream(key, scm.getProject());
                    }
                    dmSCM.logout(key);
                }
                InetAddress netAddr = InetAddress.getLocalHost();
                byte[] ipAddr = netAddr.getAddress();
                String hostname = netAddr.getHostName();
                String projectName = build.getProject().getName();
                int buildNo = build.getNumber();
                Logger.Debug("Checking if master or slave...");
                boolean master = true;
                if (nodeName != null && nodeName.length() > 0) {
                    master = false;
                }
                if (master) {
                    listener.getLogger().println("[DIMENSIONS] Running checkin on master...");
                    listener.getLogger().flush();
                    CheckInAPITask task = new CheckInAPITask(build, scm, buildNo, projectName, version, this, workspace, (TaskListener)listener);
                    bRet = (Boolean)workspace.act((FilePath.FileCallable)task);
                } else {
                    VariableResolver myResolver = build.getBuildVariableResolver();
                    String requests = (String)myResolver.resolve("DM_TARGET_REQUEST");
                    listener.getLogger().println("[DIMENSIONS] Running checkin on slave...");
                    listener.getLogger().flush();
                    CheckInCmdTask task = new CheckInCmdTask(scm.getJobUserName(), scm.getJobPasswd(), scm.getJobDatabase(), scm.getJobServer(), scm.getProject(), requests, this.isForceCheckIn(), this.isForceTip(), this.getPatterns(), version, isStream, buildNo, projectName, this.getOwningPart(), workspace, (TaskListener)listener);
                    bRet = (Boolean)workspace.act((FilePath.FileCallable)task);
                }
            } else {
                bRet = true;
            }
            if (!bRet) {
                build.setResult(Result.FAILURE);
            }
        }
        catch (Exception e) {
            listener.fatalError("Unable to load build artifacts into Dimensions - " + e.getMessage());
            build.setResult(Result.FAILURE);
            boolean bl = false;
            return bl;
        }
        return bRet;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public DescriptorImpl() {
            super(ArtifactUploader.class);
            this.load();
            Logger.Debug("Loading " + ((Object)((Object)this)).getClass().getName());
        }

        public String getDisplayName() {
            return "Load any build artifacts into the Dimensions repository";
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            req.bindParameters((Object)this, "ArtifactUploader");
            return super.configure(req, formData);
        }

        public Notifier newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            String[] patterns = req.getParameterValues("artifactuploader.patterns");
            Boolean fTip = "on".equalsIgnoreCase(req.getParameter("artifactuploader.forceCheckIn"));
            Boolean fMerge = "on".equalsIgnoreCase(req.getParameter("artifactuploader.forceTip"));
            String oPart = req.getParameter("artifactuploader.owningPart");
            if (oPart != null) {
                oPart = Util.fixNull((String)req.getParameter("artifactuploader.owningPart").trim());
            }
            ArtifactUploader artifactor = new ArtifactUploader(patterns, fTip, fMerge, oPart);
            return artifactor;
        }
    }
}

