/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.dimensionsscm;

import com.serena.dmclient.api.DimensionsResult;
import hudson.Extension;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Result;
import hudson.plugins.dimensionsscm.DimensionsSCM;
import hudson.plugins.dimensionsscm.Logger;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Notifier;
import hudson.tasks.Publisher;
import hudson.util.VariableResolver;
import java.io.IOException;
import java.io.Serializable;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DimensionsBuildNotifier
extends Notifier
implements Serializable {
    private static DimensionsSCM scm = null;
    private boolean canBaselineDeploy = false;
    private boolean canBaselineAction = false;
    private String actionState = null;
    private String deployState = null;
    private String blnScope = null;
    private String blnName = null;
    private String blnTemplate = null;
    private String blnOwningPart = null;
    private String blnType = null;
    private boolean canBaselineBuild = false;
    private String area = null;
    private String buildConfig = null;
    private String buildOptions = null;
    private String buildTargets = null;
    private boolean batch = false;
    private boolean buildClean = false;
    private boolean capture = false;

    public String getBlnOwningPart() {
        return this.blnOwningPart;
    }

    public String getBlnType() {
        return this.blnType;
    }

    public String getBlnTemplate() {
        return this.blnTemplate;
    }

    public String getBlnName() {
        return this.blnName;
    }

    public String getBlnScope() {
        return this.blnScope;
    }

    public boolean isCanBaselineBuild() {
        return this.canBaselineBuild;
    }

    public boolean isCanBaselineAction() {
        return this.canBaselineAction;
    }

    public boolean isCanBaselineDeploy() {
        return this.canBaselineDeploy;
    }

    public boolean isBatch() {
        return this.batch;
    }

    public boolean isBuildClean() {
        return this.buildClean;
    }

    public boolean isCapture() {
        return this.capture;
    }

    public String getActionState() {
        return this.actionState;
    }

    public String getDeployState() {
        return this.deployState;
    }

    public String getArea() {
        return this.area;
    }

    public String getBuildConfig() {
        return this.buildConfig;
    }

    public String getBuildOptions() {
        return this.buildOptions;
    }

    public String getBuildTargets() {
        return this.buildTargets;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public DimensionsBuildNotifier(boolean canDeploy, String deployState, boolean canAction, String actionState, boolean canBuild, String area, String buildConfig, String buildOptions, String buildTargets, String blnScope, String blnTemplate, String blnOwningPart, String blnType, String blnName, boolean batch, boolean buildClean, boolean capture) {
        this.canBaselineDeploy = canDeploy;
        this.canBaselineAction = canAction;
        this.canBaselineBuild = canBuild;
        this.actionState = actionState;
        this.deployState = deployState;
        this.area = area;
        this.buildConfig = buildConfig;
        this.buildOptions = buildOptions;
        this.buildTargets = buildTargets;
        this.blnScope = blnScope;
        this.blnTemplate = blnTemplate;
        this.blnOwningPart = blnOwningPart;
        this.blnType = blnType;
        this.blnName = blnName;
        this.batch = batch;
        this.buildClean = buildClean;
        this.capture = capture;
    }

    public boolean needsToRunAfterFinalized() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        block23: {
            Logger.Debug("Invoking perform callout " + this.getClass().getName());
            long key = -1L;
            try {
                if (!(build.getProject().getScm() instanceof DimensionsSCM)) {
                    listener.fatalError("[DIMENSIONS] This plugin only works with the Dimensions SCM engine.");
                    build.setResult(Result.FAILURE);
                    throw new IOException("[DIMENSIONS] This plugin only works with a Dimensions SCM engine");
                }
                if (build.getResult() != Result.SUCCESS) break block23;
                if (scm == null) {
                    scm = (DimensionsSCM)build.getProject().getScm();
                }
                Logger.Debug("Dimensions user is " + scm.getJobUserName() + " , Dimensions installation is " + scm.getJobServer());
                key = scm.getAPI().login(scm.getJobUserName(), scm.getJobPasswd(), scm.getJobDatabase(), scm.getJobServer());
                if (key > 0L) {
                    VariableResolver myResolver = build.getBuildVariableResolver();
                    String requests = (String)myResolver.resolve("DM_TARGET_REQUEST");
                    String blnId = (String)myResolver.resolve("DM_BASELINE");
                    StringBuffer cblId = new StringBuffer();
                    if (requests != null) {
                        requests = requests.replaceAll(" ", "");
                        requests = requests.toUpperCase();
                    }
                    if (this.blnScope != null && this.blnScope.length() > 0 && this.blnScope.equals("REVISED") && (requests == null || blnId == null || requests.length() == 0 || blnId.length() == 0)) {
                        listener.fatalError("[DIMENSIONS] A revised baseline is only valid if you have specified DM_TARGET_REQUEST and DM_BASELINE.");
                        build.setResult(Result.FAILURE);
                        boolean bl = false;
                        return bl;
                    }
                    DimensionsResult res = scm.getAPI().createBaseline(key, scm.getProject(), build, this.blnScope, this.blnTemplate, this.blnOwningPart, this.blnType, requests, blnId, this.blnName, cblId);
                    if (res == null) {
                        listener.getLogger().println("[DIMENSIONS] The build failed to be tagged in Dimensions");
                        listener.getLogger().flush();
                        build.setResult(Result.FAILURE);
                        this.canBaselineBuild = false;
                        this.canBaselineAction = false;
                        this.canBaselineDeploy = false;
                    } else {
                        listener.getLogger().println("[DIMENSIONS] Build was successfully tagged in Dimensions as a baseline");
                        listener.getLogger().println("[DIMENSIONS] (" + res.getMessage().replaceAll("\n", "\n[DIMENSIONS] ") + ")");
                        listener.getLogger().flush();
                    }
                    if (this.canBaselineDeploy) {
                        listener.getLogger().println("[DIMENSIONS] Submitting a deployment job to Dimensions...");
                        listener.getLogger().flush();
                        res = scm.getAPI().deployBaseline(key, scm.getProject(), build, this.deployState, cblId.toString());
                        if (res == null) {
                            listener.getLogger().println("[DIMENSIONS] The build baseline failed to be deployed in Dimensions");
                            listener.getLogger().flush();
                            build.setResult(Result.FAILURE);
                            this.canBaselineBuild = false;
                            this.canBaselineAction = false;
                            this.canBaselineDeploy = false;
                        } else {
                            listener.getLogger().println("[DIMENSIONS] Build baseline was successfully deployed in Dimensions");
                            listener.getLogger().println("[DIMENSIONS] (" + res.getMessage().replaceAll("\n", "\n[DIMENSIONS] ") + ")");
                            listener.getLogger().flush();
                        }
                    }
                    if (this.canBaselineBuild) {
                        listener.getLogger().println("[DIMENSIONS] Submitting a build job to Dimensions...");
                        listener.getLogger().flush();
                        res = scm.getAPI().buildBaseline(key, this.area, scm.getProject(), this.batch, this.buildClean, this.buildConfig, this.buildOptions, this.capture, requests, this.buildTargets, build, cblId.toString());
                        if (res == null) {
                            listener.getLogger().println("[DIMENSIONS] The build baseline failed to be built in Dimensions");
                            listener.getLogger().flush();
                            build.setResult(Result.FAILURE);
                            this.canBaselineBuild = false;
                            this.canBaselineAction = false;
                            this.canBaselineDeploy = false;
                        } else {
                            listener.getLogger().println("[DIMENSIONS] Build baseline was successfully built in Dimensions");
                            listener.getLogger().println("[DIMENSIONS] (" + res.getMessage().replaceAll("\n", "\n[DIMENSIONS] ") + ")");
                            listener.getLogger().flush();
                        }
                    }
                    if (this.canBaselineAction) {
                        listener.getLogger().println("[DIMENSIONS] Actioning the build baseline in Dimensions...");
                        listener.getLogger().flush();
                        res = scm.getAPI().actionBaseline(key, scm.getProject(), build, this.actionState, cblId.toString());
                        if (res == null) {
                            listener.getLogger().println("[DIMENSIONS] The build baseline failed to be actioned in Dimensions");
                            build.setResult(Result.FAILURE);
                            listener.getLogger().flush();
                        } else {
                            listener.getLogger().println("[DIMENSIONS] Build baseline was successfully actioned in Dimensions");
                            listener.getLogger().println("[DIMENSIONS] (" + res.getMessage().replaceAll("\n", "\n[DIMENSIONS] ") + ")");
                            listener.getLogger().flush();
                        }
                    }
                    break block23;
                }
                listener.fatalError("[DIMENSIONS] Login to Dimensions failed.");
                build.setResult(Result.FAILURE);
                boolean myResolver = false;
                return myResolver;
            }
            catch (Exception e) {
                listener.fatalError("Unable to tag build in Dimensions - " + e.getMessage());
                build.setResult(Result.FAILURE);
                boolean bl = false;
                return bl;
            }
            finally {
                if (scm != null) {
                    scm.getAPI().logout(key);
                }
            }
        }
        return true;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public DescriptorImpl() {
            super(DimensionsBuildNotifier.class);
            this.load();
            Logger.Debug("Loading " + ((Object)((Object)this)).getClass().getName());
        }

        public String getDisplayName() {
            return "Tag successful builds in Dimensions as a baseline";
        }

        public Notifier newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            Boolean canDeploy = "on".equalsIgnoreCase(req.getParameter("dimensionsbuildnotifier.canBaselineDeploy"));
            Boolean canBuild = "on".equalsIgnoreCase(req.getParameter("dimensionsbuildnotifier.canBaselineBuild"));
            Boolean canAction = "on".equalsIgnoreCase(req.getParameter("dimensionsbuildnotifier.canBaselineAction"));
            Boolean batch = "on".equalsIgnoreCase(req.getParameter("dimensionsbuildnotifier.batch"));
            Boolean buildClean = "on".equalsIgnoreCase(req.getParameter("dimensionsbuildnotifier.buildClean"));
            Boolean capture = "on".equalsIgnoreCase(req.getParameter("dimensionsbuildnotifier.capture"));
            String deploy = req.getParameter("dimensionsbuildnotifier.deployState");
            String action = req.getParameter("dimensionsbuildnotifier.actionState");
            String area = req.getParameter("dimensionsbuildnotifier.area");
            String buildConfig = req.getParameter("dimensionsbuildnotifier.buildConfig");
            String buildOptions = req.getParameter("dimensionsbuildnotifier.buildOptions");
            String buildTargets = req.getParameter("dimensionsbuildnotifier.buildTargets");
            String blnScope = req.getParameter("dimensionsbuildnotifier.blnScope");
            String blnTemplate = req.getParameter("dimensionsbuildnotifier.blnTemplate");
            String blnOwningPart = req.getParameter("dimensionsbuildnotifier.blnOwningPart");
            String blnType = req.getParameter("dimensionsbuildnotifier.blnType");
            String blnName = req.getParameter("dimensionsbuildnotifier.blnName");
            if (deploy != null) {
                deploy = Util.fixNull((String)req.getParameter("dimensionsbuildnotifier.deployState").trim());
            }
            if (action != null) {
                action = Util.fixNull((String)req.getParameter("dimensionsbuildnotifier.actionState").trim());
            }
            if (area != null) {
                area = Util.fixNull((String)req.getParameter("dimensionsbuildnotifier.area").trim());
            }
            if (buildConfig != null) {
                buildConfig = Util.fixNull((String)req.getParameter("dimensionsbuildnotifier.buildConfig").trim());
            }
            if (buildOptions != null) {
                buildOptions = Util.fixNull((String)req.getParameter("dimensionsbuildnotifier.buildOptions").trim());
            }
            if (buildTargets != null) {
                buildTargets = Util.fixNull((String)req.getParameter("dimensionsbuildnotifier.buildTargets").trim());
            }
            if (blnScope != null) {
                blnScope = Util.fixNull((String)req.getParameter("dimensionsbuildnotifier.blnScope").trim());
            }
            if (blnTemplate != null) {
                blnTemplate = Util.fixNull((String)req.getParameter("dimensionsbuildnotifier.blnTemplate").trim());
            }
            if (blnOwningPart != null) {
                blnOwningPart = Util.fixNull((String)req.getParameter("dimensionsbuildnotifier.blnOwningPart").trim());
            }
            if (blnType != null) {
                blnType = Util.fixNull((String)req.getParameter("dimensionsbuildnotifier.blnType").trim());
            }
            if (blnName != null) {
                blnName = Util.fixNull((String)req.getParameter("dimensionsbuildnotifier.blnName").trim());
            }
            DimensionsBuildNotifier notif = new DimensionsBuildNotifier(canDeploy, deploy, canAction, action, canBuild, area, buildConfig, buildOptions, buildTargets, blnScope, blnTemplate, blnOwningPart, blnType, blnName, batch, buildClean, capture);
            return notif;
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            String deploy = req.getParameter("dimensionsbuildnotifier.deployState");
            String action = req.getParameter("dimensionsbuildnotifier.actionState");
            if (deploy != null) {
                deploy = Util.fixNull((String)req.getParameter("dimensionsbuildnotifier.deployState").trim());
            }
            if (action != null) {
                action = Util.fixNull((String)req.getParameter("dimensionsbuildnotifier.actionState").trim());
            }
            this.save();
            return super.configure(req, formData);
        }

        public String getHelpFile() {
            return "/plugin/dimensionsscm/helpbnotifier.html";
        }
    }
}

