/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.dimensionsscm;

import java.io.File;
import java.io.FilenameFilter;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.Vector;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileScanner
implements Serializable {
    private File[] arr = null;
    private Collection<File> xfiles = null;
    private File baseDir = null;
    private ScannerFilter filter = null;

    public FileScanner(File dirName, String[] patterns, int depth) {
        this.baseDir = dirName;
        this.filter = new ScannerFilter(patterns);
        this.xfiles = this.scanFiles(dirName, this.filter, depth);
    }

    public Collection<File> getFiles() {
        return this.xfiles;
    }

    public File[] toArray() {
        this.arr = new File[this.xfiles.size()];
        return this.xfiles.toArray(this.arr);
    }

    private Collection<File> scanFiles(File dirName, FilenameFilter filter, int depth) {
        if (dirName.isDirectory()) {
            // empty if block
        }
        Vector<File> files = new Vector<File>();
        File[] entFiles = dirName.listFiles();
        if (!(dirName.isDirectory() && dirName.getName().equals(".metadata") || entFiles == null)) {
            for (File afile : entFiles) {
                String dname = afile.getAbsolutePath();
                if (afile.getName().equals(".metadata")) continue;
                dname = dname.substring(this.baseDir.getAbsolutePath().length() + 1, afile.getAbsolutePath().length());
                if (filter == null || filter.accept(dirName, dname)) {
                    files.add(afile);
                }
                if (depth > -1 && (depth <= 0 || !afile.isDirectory())) continue;
                files.addAll(this.scanFiles(afile, filter, --depth));
                ++depth;
            }
        }
        return files;
    }

    public class ScannerFilter
    implements FilenameFilter {
        private TreeSet<String> artifactFilter = new TreeSet();

        public ScannerFilter(String[] extensions) {
            Iterator<String> artifactList = Arrays.asList(extensions).iterator();
            while (artifactList.hasNext()) {
                this.artifactFilter.add(artifactList.next().trim());
            }
            this.artifactFilter.remove("");
        }

        public boolean accept(File dir, String name) {
            Iterator<String> artifactList = this.artifactFilter.iterator();
            if (name.equals(".metadata")) {
                return false;
            }
            while (artifactList.hasNext()) {
                String filter = artifactList.next();
                if (!Pattern.matches(filter, name)) continue;
                return true;
            }
            return false;
        }
    }
}

