/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.disk_usage;

import hudson.FilePath;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.AsyncPeriodicWork;
import hudson.model.Hudson;
import hudson.model.ItemGroup;
import hudson.model.JobProperty;
import hudson.model.TaskListener;
import hudson.plugins.disk_usage.BuildDiskUsageAction;
import hudson.plugins.disk_usage.DiskUsageProperty;
import hudson.plugins.disk_usage.DiskUsageThread;
import hudson.plugins.disk_usage.ProjectDiskUsageAction;
import hudson.remoting.Callable;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;

/*
 * Exception performing whole class analysis ignored.
 */
public class DiskUsageThread
extends AsyncPeriodicWork {
    public static final int COUNT_INTERVAL_MINUTES = 360;

    public DiskUsageThread() {
        super("Project disk usage");
    }

    public long getRecurrencePeriod() {
        return 21600000L;
    }

    protected void execute(TaskListener listener) throws IOException, InterruptedException {
        List items = Hudson.getInstance().getItems();
        for (Object item : Hudson.getInstance().getItems()) {
            if (!(item instanceof ItemGroup)) continue;
            items.addAll(((ItemGroup)item).getItems());
        }
        for (Object item : items) {
            if (!(item instanceof AbstractProject)) continue;
            AbstractProject project = (AbstractProject)item;
            if (project.getAction(ProjectDiskUsageAction.class) == null) {
                try {
                    project.addProperty((JobProperty)new DiskUsageProperty());
                    project.save();
                }
                catch (IOException ex) {
                    this.logger.log(Level.WARNING, "Error when adding disk usage property for " + project.getName(), ex);
                    break;
                }
            }
            if (project.isBuilding()) continue;
            List builds = project.getBuilds();
            Iterator buildIterator = builds.iterator();
            try {
                while (buildIterator.hasNext()) {
                    DiskUsageThread.calculateDiskUsageForBuild((AbstractBuild)((AbstractBuild)buildIterator.next()));
                }
                DiskUsageThread.calculateWorkspaceDiskUsage((AbstractProject)project);
            }
            catch (Exception ex) {
                this.logger.log(Level.WARNING, "Error when recording disk usage for " + project.getName(), ex);
            }
        }
    }

    private static void calculateDiskUsageForBuild(AbstractBuild build) throws IOException {
        long buildSize = DiskUsageCallable.getFileSize((File)build.getRootDir());
        BuildDiskUsageAction action = (BuildDiskUsageAction)build.getAction(BuildDiskUsageAction.class);
        boolean updateBuild = false;
        if (action == null) {
            action = new BuildDiskUsageAction(build, 0L, buildSize);
            build.addAction((Action)action);
            updateBuild = true;
        } else if (action.diskUsage.buildUsage <= 0L || Math.abs(action.diskUsage.buildUsage - buildSize) > 1024L) {
            action.diskUsage.buildUsage = buildSize;
            updateBuild = true;
        }
        if (updateBuild) {
            build.save();
        }
    }

    private static void calculateWorkspaceDiskUsage(AbstractProject project) throws IOException, InterruptedException {
        AbstractBuild lastBuild = (AbstractBuild)project.getLastBuild();
        if (lastBuild != null) {
            FilePath workspace;
            BuildDiskUsageAction bdua = (BuildDiskUsageAction)lastBuild.getAction(BuildDiskUsageAction.class);
            boolean updateWs = false;
            if (bdua == null) {
                bdua = new BuildDiskUsageAction(lastBuild, 0L, 0L);
                lastBuild.addAction((Action)bdua);
                updateWs = true;
            }
            if ((workspace = project.getSomeWorkspace()) != null) {
                long oldWsUsage = bdua.diskUsage.wsUsage;
                bdua.diskUsage.wsUsage = (Long)workspace.act((Callable)new DiskUsageCallable(workspace));
                if (Math.abs(bdua.diskUsage.wsUsage - oldWsUsage) > 1024L) {
                    updateWs = true;
                }
            } else {
                bdua.diskUsage.wsUsage = 0L;
            }
            if (updateWs) {
                lastBuild.save();
            }
        }
    }
}

