/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.disk_usage;

import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Hudson;
import hudson.model.Run;
import hudson.plugins.disk_usage.BuildDiskUsageAction;
import hudson.plugins.disk_usage.DiskUsage;
import hudson.plugins.disk_usage.DiskUsageAction;
import hudson.plugins.disk_usage.DiskUsageProperty;
import hudson.util.ChartUtil;
import hudson.util.ColorPalette;
import hudson.util.DataSetBuilder;
import hudson.util.ShiftedCategoryAxis;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Stroke;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.LineAndShapeRenderer;
import org.jfree.chart.title.LegendTitle;
import org.jfree.data.category.CategoryDataset;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.RectangleInsets;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectDiskUsageAction
extends DiskUsageAction {
    AbstractProject<? extends AbstractProject, ? extends AbstractBuild> project;

    public ProjectDiskUsageAction(AbstractProject<? extends AbstractProject, ? extends AbstractBuild> project) {
        this.project = project;
    }

    @Override
    public String getUrlName() {
        return "disk-usage";
    }

    public DiskUsage getDiskUsage() {
        DiskUsage du = new DiskUsage(0L, 0L);
        if (this.project != null) {
            BuildDiskUsageAction action = null;
            Iterator buildIterator = this.project.getBuilds().iterator();
            while (action == null && buildIterator.hasNext()) {
                action = (BuildDiskUsageAction)((AbstractBuild)buildIterator.next()).getAction(BuildDiskUsageAction.class);
            }
            if (action != null) {
                DiskUsage bdu = action.getDiskUsage();
                du.wsUsage = bdu.getWsUsage();
                du.buildUsage += bdu.getBuildUsage();
            }
            while (buildIterator.hasNext()) {
                action = (BuildDiskUsageAction)((AbstractBuild)buildIterator.next()).getAction(BuildDiskUsageAction.class);
                if (action == null) continue;
                du.buildUsage += action.getDiskUsage().getBuildUsage();
            }
        }
        return du;
    }

    public BuildDiskUsageAction getLastBuildAction() {
        Run run = this.project.getLastBuild();
        if (run != null) {
            return (BuildDiskUsageAction)run.getAction(BuildDiskUsageAction.class);
        }
        return null;
    }

    public void doGraph(StaplerRequest req, StaplerResponse rsp) throws IOException {
        if (ChartUtil.awtProblemCause != null) {
            rsp.sendRedirect2(req.getContextPath() + "/images/headless.png");
            return;
        }
        DataSetBuilder dsb = new DataSetBuilder();
        ArrayList<Object[]> usages = new ArrayList<Object[]>();
        long maxValue = 0L;
        for (AbstractBuild build : this.project.getBuilds()) {
            BuildDiskUsageAction dua = (BuildDiskUsageAction)build.getAction(BuildDiskUsageAction.class);
            if (dua == null) continue;
            DiskUsage usage = dua.getDiskUsage();
            maxValue = Math.max(maxValue, Math.max(usage.wsUsage, usage.getBuildUsage()));
            usages.add(new Object[]{build, usage.wsUsage, usage.getBuildUsage()});
        }
        int floor = (int)DiskUsage.getScale(maxValue);
        String unit = DiskUsage.getUnitString(floor);
        double base = Math.pow(1024.0, floor);
        for (Object[] usage : usages) {
            ChartUtil.NumberOnlyBuildLabel label = new ChartUtil.NumberOnlyBuildLabel((AbstractBuild)usage[0]);
            dsb.add((Number)((double)((Long)usage[1]).longValue() / base), (Comparable)((Object)"workspace"), (Comparable)label);
            dsb.add((Number)((double)((Long)usage[2]).longValue() / base), (Comparable)((Object)"build"), (Comparable)label);
        }
        ChartUtil.generateGraph((StaplerRequest)req, (StaplerResponse)rsp, (JFreeChart)this.createChart(req, dsb.build(), unit), (int)350, (int)150);
    }

    private JFreeChart createChart(StaplerRequest req, CategoryDataset dataset, String unit) {
        JFreeChart chart = ChartFactory.createLineChart(null, null, (String)("disk usage (" + unit + ")"), (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        LegendTitle legend = chart.getLegend();
        legend.setPosition(RectangleEdge.RIGHT);
        chart.setBackgroundPaint((Paint)Color.white);
        CategoryPlot plot = chart.getCategoryPlot();
        plot.setBackgroundPaint((Paint)Color.WHITE);
        plot.setOutlinePaint(null);
        plot.setRangeGridlinesVisible(true);
        plot.setRangeGridlinePaint((Paint)Color.black);
        ShiftedCategoryAxis domainAxis = new ShiftedCategoryAxis(null);
        plot.setDomainAxis((CategoryAxis)domainAxis);
        domainAxis.setCategoryLabelPositions(CategoryLabelPositions.UP_90);
        domainAxis.setLowerMargin(0.0);
        domainAxis.setUpperMargin(0.0);
        domainAxis.setCategoryMargin(0.0);
        NumberAxis rangeAxis = (NumberAxis)plot.getRangeAxis();
        rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        rangeAxis.setLowerBound(0.0);
        LineAndShapeRenderer renderer = (LineAndShapeRenderer)plot.getRenderer();
        renderer.setStroke((Stroke)new BasicStroke(4.0f));
        ColorPalette.apply((LineAndShapeRenderer)renderer);
        plot.setInsets(new RectangleInsets(5.0, 0.0, 0.0, 5.0));
        return chart;
    }

    public boolean showGraph() {
        return ((DiskUsageProperty.DiskUsageDescriptor)Hudson.getInstance().getDescriptorByType(DiskUsageProperty.DiskUsageDescriptor.class)).isShowGraph();
    }
}

