/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.disk_usage;

import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildBadgeAction;
import hudson.model.ItemGroup;
import hudson.model.Job;
import hudson.plugins.disk_usage.DiskUsage;
import hudson.plugins.disk_usage.DiskUsageAction;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildDiskUsageAction
extends DiskUsageAction
implements BuildBadgeAction {
    DiskUsage diskUsage;
    AbstractBuild build;

    public BuildDiskUsageAction(AbstractBuild build, long wsUsage, long buildUsage) {
        this.diskUsage = new DiskUsage(buildUsage, wsUsage);
        this.build = build;
    }

    public DiskUsage getDiskUsage() {
        DiskUsage du = this.diskUsage != null ? new DiskUsage(this.diskUsage.buildUsage, this.diskUsage.wsUsage) : new DiskUsage(0L, 0L);
        for (AbstractBuild child : BuildDiskUsageAction.getChildBuilds(this.build)) {
            BuildDiskUsageAction bdua = (BuildDiskUsageAction)child.getAction(BuildDiskUsageAction.class);
            if (bdua == null) continue;
            du.buildUsage += bdua.diskUsage.getBuildUsage();
        }
        return du;
    }

    private static List<AbstractBuild> getChildBuilds(AbstractBuild build) {
        LinkedList<AbstractBuild> result = new LinkedList<AbstractBuild>();
        Job project = build.getParent();
        if (project instanceof ItemGroup) {
            for (Object child : ((ItemGroup)project).getItems()) {
                if (!(child instanceof AbstractProject)) continue;
                AbstractBuild nextBuild = (AbstractBuild)build.getNextBuild();
                Integer nextBuildNumber = nextBuild != null ? nextBuild.getNumber() : Integer.MAX_VALUE;
                for (AbstractBuild childBuild = (AbstractBuild)((AbstractProject)child).getNearestBuild(build.getNumber()); childBuild != null && childBuild.getNumber() < nextBuildNumber; childBuild = (AbstractBuild)childBuild.getNextBuild()) {
                    result.add(childBuild);
                }
            }
        }
        return result;
    }
}

