/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.disk_usage;

public class DiskUsage {
    long buildUsage = 0L;
    long wsUsage = 0L;

    public DiskUsage() {
    }

    public DiskUsage(long buildDiskUsage, long wsDiskUsage) {
        this.buildUsage = buildDiskUsage;
        this.wsUsage = wsDiskUsage;
    }

    public long getBuildUsage() {
        return this.buildUsage;
    }

    public long getWsUsage() {
        return this.wsUsage;
    }

    public String getBuildUsageString() {
        return DiskUsage.getSizeString(this.buildUsage);
    }

    public String getWsUsageString() {
        return DiskUsage.getSizeString(this.wsUsage);
    }

    public static final String getSizeString(Long size) {
        if (size == null || size <= 0L) {
            return "-";
        }
        int floor = (int)DiskUsage.getScale(size);
        floor = Math.min(floor, 4);
        double base = Math.pow(1024.0, floor);
        String unit = DiskUsage.getUnitString(floor);
        return Math.round((double)size.longValue() / base) + unit;
    }

    public static final double getScale(long number) {
        return Math.floor(Math.log(number) / Math.log(1024.0));
    }

    public static String getUnitString(int floor) {
        String unit = "";
        switch (floor) {
            case 0: {
                unit = "B";
                break;
            }
            case 1: {
                unit = "KB";
                break;
            }
            case 2: {
                unit = "MB";
                break;
            }
            case 3: {
                unit = "GB";
                break;
            }
            case 4: {
                unit = "TB";
            }
        }
        return unit;
    }
}

