/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.disk_usage;

import hudson.Plugin;
import hudson.Util;
import hudson.model.AbstractProject;
import hudson.model.Hudson;
import hudson.model.Job;
import hudson.model.ManagementLink;
import hudson.plugins.disk_usage.DiskUsage;
import hudson.plugins.disk_usage.DiskUsageThread;
import hudson.plugins.disk_usage.ProjectDiskUsageAction;
import hudson.triggers.Trigger;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.TimerTask;
import javax.servlet.ServletException;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public class DiskUsagePlugin
extends Plugin {
    public static final int COUNT_INTERVAL_MINUTES = 15;
    private final transient DiskUsageThread duThread = new DiskUsageThread();

    public void start() throws Exception {
        ManagementLink.LIST.add(new ManagementLink(){
            public final String[] COLUMNS = new String[]{"Project name", "Builds", "Workspace"};

            public String getIconFileName() {
                return "/plugin/disk-usage/icons/diskusage48.png";
            }

            public String getDisplayName() {
                return "Disk usage";
            }

            public String getUrlName() {
                return "plugin/disk-usage/";
            }

            public String getDescription() {
                return "Displays per-project disk usage";
            }
        });
        Trigger.timer.scheduleAtFixedRate((TimerTask)((Object)this.duThread), 900000L, 900000L);
    }

    public static DiskUsage getDiskUsage(Job project) {
        ProjectDiskUsageAction action = (ProjectDiskUsageAction)project.getAction(ProjectDiskUsageAction.class);
        if (action != null) {
            return action.getDiskUsage();
        }
        return new DiskUsage(0L, 0L);
    }

    public static String getProjectUrl(Job project) {
        return Util.encode((String)project.getAbsoluteUrl());
    }

    public static List getProjectList() {
        Comparator<AbstractProject> comparator = new Comparator<AbstractProject>(){

            @Override
            public int compare(AbstractProject o1, AbstractProject o2) {
                DiskUsage du1 = DiskUsagePlugin.getDiskUsage((Job)o1);
                DiskUsage du2 = DiskUsagePlugin.getDiskUsage((Job)o2);
                return (int)(du1.wsUsage + du1.buildUsage - du2.wsUsage - du2.buildUsage);
            }
        };
        List projectList = Util.createSubList((Collection)Hudson.getInstance().getItems(), AbstractProject.class);
        Collections.sort(projectList, comparator);
        return projectList;
    }

    public void doRecordDiskUsage(StaplerRequest req, StaplerResponse res) throws ServletException, IOException {
        this.duThread.doRun();
        res.forwardToPreviousPage(req);
    }
}

