/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.disk_usage;

import hudson.FilePath;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Hudson;
import hudson.model.ItemGroup;
import hudson.model.JobProperty;
import hudson.model.PeriodicWork;
import hudson.plugins.disk_usage.BuildDiskUsageAction;
import hudson.plugins.disk_usage.DiskUsageProperty;
import hudson.plugins.disk_usage.DiskUsageThread;
import hudson.plugins.disk_usage.ProjectDiskUsageAction;
import hudson.remoting.Callable;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;

/*
 * Exception performing whole class analysis ignored.
 */
public class DiskUsageThread
extends PeriodicWork {
    public DiskUsageThread() {
        super("Disk usage");
    }

    protected void execute() {
        this.logger.log(Level.INFO, "Starting disk usage thread");
        List items = Hudson.getInstance().getItems();
        for (Object item : Hudson.getInstance().getItems()) {
            if (!(item instanceof ItemGroup)) continue;
            items.addAll(((ItemGroup)item).getItems());
        }
        for (Object item : items) {
            if (!(item instanceof AbstractProject)) continue;
            AbstractProject project = (AbstractProject)item;
            if (project.getAction(ProjectDiskUsageAction.class) == null) {
                try {
                    project.addProperty((JobProperty)new DiskUsageProperty());
                    project.save();
                }
                catch (IOException ex) {
                    this.logger.log(Level.WARNING, "Error when adding disk usage property for " + project.getName(), ex);
                    break;
                }
            }
            if (project.isBuilding()) continue;
            List builds = project.getBuilds();
            Iterator buildIterator = builds.iterator();
            try {
                if (buildIterator.hasNext()) {
                    DiskUsageThread.calculateDiskUsageForBuild((AbstractBuild)((AbstractBuild)buildIterator.next()), (boolean)true);
                }
                while (buildIterator.hasNext()) {
                    DiskUsageThread.calculateDiskUsageForBuild((AbstractBuild)((AbstractBuild)buildIterator.next()), (boolean)false);
                }
            }
            catch (Exception ex) {
                this.logger.log(Level.WARNING, "Error when recording disk usage for " + project.getName(), ex);
            }
        }
    }

    private static void calculateDiskUsageForBuild(AbstractBuild build, boolean countWorkspace) throws IOException, InterruptedException {
        if (build.isBuilding()) {
            return;
        }
        BuildDiskUsageAction bdua = (BuildDiskUsageAction)build.getAction(BuildDiskUsageAction.class);
        if (bdua == null) {
            FilePath workspace;
            AbstractProject parent;
            AbstractBuild lastBuild;
            long wsUsage = 0L;
            if (countWorkspace && (lastBuild = (AbstractBuild)(parent = build.getProject()).getLastBuild()) != null && (workspace = parent.getWorkspace()) != null) {
                wsUsage = (Long)workspace.act((Callable)new DiskUsageCallable(workspace));
            }
            long buildSize = DiskUsageCallable.getFileSize((File)build.getRootDir());
            BuildDiskUsageAction action = new BuildDiskUsageAction(build, wsUsage, buildSize);
            build.addAction((Action)action);
            build.save();
        }
    }
}

