/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.disk_usage;

import hudson.Plugin;
import hudson.Util;
import hudson.model.AbstractProject;
import hudson.model.Hudson;
import hudson.model.Job;
import hudson.model.Jobs;
import hudson.model.ManagementLink;
import hudson.plugins.disk_usage.DiskUsage;
import hudson.plugins.disk_usage.DiskUsageProperty;
import hudson.plugins.disk_usage.DiskUsageThread;
import hudson.plugins.disk_usage.ProjectDiskUsageAction;
import hudson.triggers.Trigger;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.TimerTask;
import javax.servlet.ServletException;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public class DiskUsagePlugin
extends Plugin {
    public static final int COUNT_INTERVAL_MINUTES = 60;
    private final transient DiskUsageThread duThread = new DiskUsageThread();
    private static DiskUsage diskUsageSum;

    public void start() throws Exception {
        ManagementLink.LIST.add(new ManagementLink(){
            public final String[] COLUMNS = new String[]{"Project name", "Builds", "Workspace"};

            public String getIconFileName() {
                return "/plugin/disk-usage/icons/diskusage48.png";
            }

            public String getDisplayName() {
                return "Disk usage";
            }

            public String getUrlName() {
                return "plugin/disk-usage/";
            }

            public String getDescription() {
                return "Displays per-project disk usage";
            }
        });
        Jobs.PROPERTIES.add(DiskUsageProperty.DESCRIPTOR);
        Trigger.timer.scheduleAtFixedRate((TimerTask)((Object)this.duThread), 3600000L, 3600000L);
    }

    public static DiskUsage getDiskUsage(Job project) {
        ProjectDiskUsageAction action = (ProjectDiskUsageAction)project.getAction(ProjectDiskUsageAction.class);
        if (action != null) {
            return action.getDiskUsage();
        }
        return new DiskUsage(0L, 0L);
    }

    public static String getProjectUrl(Job project) {
        return Util.encode((String)project.getAbsoluteUrl());
    }

    public static List getProjectList() {
        Comparator<AbstractProject> comparator = new Comparator<AbstractProject>(){

            @Override
            public int compare(AbstractProject o1, AbstractProject o2) {
                DiskUsage du1 = DiskUsagePlugin.getDiskUsage((Job)o1);
                DiskUsage du2 = DiskUsagePlugin.getDiskUsage((Job)o2);
                long result = du2.wsUsage + du2.buildUsage - du1.wsUsage - du1.buildUsage;
                if (result > 0L) {
                    return 1;
                }
                if (result < 0L) {
                    return -1;
                }
                return 0;
            }
        };
        List projectList = Util.createSubList((Collection)Hudson.getInstance().getItems(), AbstractProject.class);
        Collections.sort(projectList, comparator);
        DiskUsage sum = new DiskUsage(0L, 0L);
        for (AbstractProject project : projectList) {
            DiskUsage du = DiskUsagePlugin.getDiskUsage((Job)project);
            sum.buildUsage += du.buildUsage;
            sum.wsUsage += du.wsUsage;
        }
        diskUsageSum = sum;
        return projectList;
    }

    public static DiskUsage getDiskUsageSum() {
        return diskUsageSum;
    }

    public void doRecordDiskUsage(StaplerRequest req, StaplerResponse res) throws ServletException, IOException {
        this.duThread.doRun();
        res.forwardToPreviousPage(req);
    }
}

