/*
 * Decompiled with CFR 0.152.
 */
package hudson.distTest;

import hudson.FilePath;
import hudson.Launcher;
import hudson.distTest.DistTestingBuilder;
import hudson.distTest.FilePathDirScanner;
import hudson.distTest.LockingTasks;
import hudson.distTest.TestFilePathVisitor;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Computer;
import hudson.model.Executor;
import hudson.model.FreeStyleProject;
import hudson.model.Hudson;
import hudson.model.Label;
import hudson.model.Node;
import hudson.model.Project;
import hudson.remoting.Callable;
import hudson.slaves.SlaveComputer;
import hudson.tasks.Builder;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import java.util.concurrent.Future;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DistTestingBuilder
extends Builder
implements Serializable {
    private DistLocations[] distLocations = new DistLocations[0];
    private LibLocations[] libLocations = new LibLocations[0];
    private final boolean waitForNodes;
    private final boolean compileTests;
    private final String testDir;
    private final String lidDir = "lib";

    @DataBoundConstructor
    public DistTestingBuilder(DistLocations[] distLocations, LibLocations[] libLocations, String testDir, boolean waitForNodes, boolean compileTests) {
        this.distLocations = distLocations;
        this.libLocations = libLocations;
        this.waitForNodes = waitForNodes;
        this.testDir = testDir;
        this.compileTests = compileTests;
    }

    private LockingTasks lockExecutors(Label label, AbstractBuild build) throws IOException, InterruptedException {
        ArrayList<Future> lockBuildList = new ArrayList<Future>();
        ArrayList<FreeStyleProject> fspList = new ArrayList<FreeStyleProject>();
        ArrayList<Node> nodeList = new ArrayList<Node>();
        Computer c = null;
        for (Node n : label.getNodes()) {
            c = n.toComputer();
            if (!c.isOnline() || !c.isIdle() || !(c instanceof SlaveComputer)) continue;
            nodeList.add(n);
            for (Executor e : c.getExecutors()) {
                if (!e.isIdle()) continue;
                String lockProjectName = "Lock-" + build.getProject().getName() + "-" + n.getDisplayName() + "-" + e.getDisplayName();
                Hudson hudson = Hudson.getInstance();
                for (Project p : hudson.getProjects()) {
                    if (!lockProjectName.equalsIgnoreCase(p.getName())) continue;
                    p.delete();
                }
                FreeStyleProject project = (FreeStyleProject)hudson.createProject(FreeStyleProject.class, lockProjectName);
                String projectName = build.getProject().getName();
                project.getBuildersList().add((Object)new /* Unavailable Anonymous Inner Class!! */);
                project.setAssignedNode(n);
                Future f = project.scheduleBuild2(0);
                lockBuildList.add(f);
                fspList.add(project);
            }
        }
        return new LockingTasks(lockBuildList, fspList, nodeList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean perform(AbstractBuild build, Launcher launcher, BuildListener listener) {
        try {
            Label label = build.getProject().getAssignedLabel();
            if (label == null) {
                throw new Exception("Set label in the \"Tie this project to a node\" section + in the project configaration.");
            }
            if (build.getBuiltOn().toComputer() instanceof Hudson.MasterComputer) {
                throw new Exception("Distributed testing task cannot be perform on master. Please change the label.");
            }
            if (this.testDir == null || "".equals(this.testDir)) {
                throw new Exception("Directory with tests must be set.");
            }
            if (label.getNodes().size() < 2) {
                throw new Exception("Number of nodes in label " + label + " must be more than one. Distributed Testing was cancelled.");
            }
            if (this.isWaitForNodes()) {
                this.waitForNodes(build, listener);
            }
            LockingTasks lockingTasks = this.lockExecutors(label, build);
            this.copyLibraries(build.getWorkspace().child("lib"));
            listener.getLogger().println("finished");
            if (this.isCompileTests()) {
                listener.getLogger().print("Compiling sources on slave " + build.getBuiltOnStr() + " :");
                this.compileTests(build);
                listener.getLogger().println("finished");
            }
            String directoryWithCompiledTests = null;
            directoryWithCompiledTests = this.compileTests ? "tests" : this.getTestDir();
            if ("\\".equals(this.getFileSeparatorForNode(build.getBuiltOn()))) {
                directoryWithCompiledTests = directoryWithCompiledTests.replace("/", "\\");
            }
            LinkedList tests = this.findTestsInProjectWorkspace(build.getWorkspace().child(directoryWithCompiledTests));
            listener.getLogger().println();
            listener.getLogger().println("Print all tests files:");
            Iterator it = tests.iterator();
            while (it.hasNext()) {
                listener.getLogger().println((String)it.next());
            }
            listener.getLogger().println();
            build.getWorkspace().child("results").mkdirs();
            ArrayList<String> listOfNodes = new ArrayList<String>();
            for (Node n : lockingTasks.getNodeList()) {
                listOfNodes.add(n.getDisplayName());
            }
            if (build.getBuiltOn().toComputer() instanceof SlaveComputer) {
                listOfNodes.add(build.getBuiltOnStr());
            }
            listener.getLogger().println();
            listener.getLogger().println("Lists all test nodes:");
            for (String node : listOfNodes) {
                listener.getLogger().println(node);
            }
            listener.getLogger().println();
            String projectName = build.getProject().getName();
            listener.getLogger().println("Call build-on slave to run tests");
            build.getWorkspace().act((FilePath.FileCallable)new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (Throwable ex) {
            ex.printStackTrace(listener.getLogger());
        }
        return true;
    }

    public String getWorkspaceForThisProjectOnNode(Node node, AbstractBuild build) throws IOException, Exception {
        String path = null;
        if (node != null && node.toComputer().isOnline()) {
            path = node.getRootPath().getRemote() + this.getFileSeparatorForNode(node) + "workspace" + this.getFileSeparatorForNode(node) + build.getProject().getName();
        }
        return path;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    private FilePath getFilePathOnMasterForClass(String className) throws ClassNotFoundException, URISyntaxException {
        FilePath f = null;
        Class<?> cls = this.getClass().getClassLoader().loadClass(className);
        ProtectionDomain pDomain = cls.getProtectionDomain();
        CodeSource cSource = pDomain.getCodeSource();
        URL url = cSource.getLocation();
        f = new FilePath(new File(url.toURI()));
        return f;
    }

    public boolean isWaitForNodes() {
        return this.waitForNodes;
    }

    private void copyLibraries(FilePath toWhere) throws IOException, InterruptedException, Exception {
        if (!toWhere.exists()) {
            toWhere.mkdirs();
        }
        FilePath junit = this.getFilePathOnMasterForClass("org.junit.runner.JUnitCore");
        FilePath antJunit = this.getFilePathOnMasterForClass("org.apache.tools.ant.taskdefs.optional.junit.JUnitTask");
        FilePath ant = this.getFilePathOnMasterForClass("org.apache.tools.ant.Project");
        junit.copyTo(toWhere.child(junit.getName()));
        antJunit.copyTo(toWhere.child(antJunit.getName()));
        ant.copyTo(toWhere.child(ant.getName()));
    }

    private LinkedList<String> findTestsInProjectWorkspace(FilePath dirWithTest) throws IOException, Exception {
        TestFilePathVisitor filePathVisitor = new TestFilePathVisitor();
        FilePathDirScanner filePathDirScanner = new FilePathDirScanner();
        filePathDirScanner.scan(dirWithTest, filePathVisitor);
        if (filePathVisitor.getListOfTests().size() <= 0) {
            throw new Exception("Could not find any test classes in the directory: " + dirWithTest);
        }
        return filePathVisitor.getListOfTests();
    }

    public String getTestDir() {
        return this.testDir;
    }

    private void compileTests(AbstractBuild build) throws IOException, InterruptedException {
        build.getWorkspace().act((FilePath.FileCallable)new /* Unavailable Anonymous Inner Class!! */);
    }

    public boolean isCompileTests() {
        return this.compileTests;
    }

    private String getFileSeparatorForNode(Node node) throws IOException, Exception {
        return (String)node.getChannel().call((Callable)new /* Unavailable Anonymous Inner Class!! */);
    }

    public DistLocations[] getDistLocations() {
        return this.distLocations;
    }

    public LibLocations[] getLibLocations() {
        return this.libLocations;
    }

    private void waitForNodes(AbstractBuild build, BuildListener listener) throws InterruptedException {
        Label label = build.getProject().getAssignedLabel();
        Set nodes = label.getNodes();
        while (true) {
            boolean allFree = true;
            for (Node n : nodes) {
                if (!n.toComputer().isOnline() || n.toComputer().isIdle() || build.getBuiltOnStr().equalsIgnoreCase(n.getNodeName())) continue;
                allFree = false;
            }
            if (allFree) {
                listener.getLogger().println("All nodes are free now.");
                return;
            }
            listener.getLogger().println("Waiting for all other nodes in label " + label);
            Thread.sleep(1000L);
        }
    }

    static /* synthetic */ boolean access$000(DistTestingBuilder x0) {
        return x0.compileTests;
    }

    static /* synthetic */ String access$100(DistTestingBuilder x0) {
        return x0.testDir;
    }
}

