/*
 * Decompiled with CFR 0.152.
 */
package hudson.distTest;

import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.distTest.FilePathDirScanner;
import hudson.distTest.LockingTasks;
import hudson.distTest.TestFilePathVisitor;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Computer;
import hudson.model.Descriptor;
import hudson.model.Executor;
import hudson.model.FreeStyleBuild;
import hudson.model.FreeStyleProject;
import hudson.model.Hudson;
import hudson.model.Label;
import hudson.model.Node;
import hudson.model.Project;
import hudson.remoting.Callable;
import hudson.remoting.Future;
import hudson.remoting.VirtualChannel;
import hudson.slaves.SlaveComputer;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.FormValidation;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import net.sf.json.JSONObject;
import org.apache.tools.ant.Target;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Javac;
import org.apache.tools.ant.taskdefs.optional.junit.FormatterElement;
import org.apache.tools.ant.taskdefs.optional.junit.JUnitTask;
import org.apache.tools.ant.taskdefs.optional.junit.JUnitTest;
import org.apache.tools.ant.types.Path;
import org.jvnet.hudson.test.TestBuilder;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DistTestingBuilder
extends Builder
implements Serializable {
    private DistLocations[] distLocations = new DistLocations[0];
    private LibLocations[] libLocations = new LibLocations[0];
    private final boolean waitForNodes;
    private final boolean compileTests;
    private final String testDir;
    private final String lidDir = "lib";

    @DataBoundConstructor
    public DistTestingBuilder(DistLocations[] distLocations, LibLocations[] libLocations, String testDir, boolean waitForNodes, boolean compileTests) {
        this.distLocations = distLocations;
        this.libLocations = libLocations;
        this.waitForNodes = waitForNodes;
        this.testDir = testDir;
        this.compileTests = compileTests;
    }

    private LockingTasks lockExecutors(Label label, AbstractBuild build) throws IOException, InterruptedException {
        ArrayList<java.util.concurrent.Future<FreeStyleBuild>> lockBuildList = new ArrayList<java.util.concurrent.Future<FreeStyleBuild>>();
        ArrayList<FreeStyleProject> fspList = new ArrayList<FreeStyleProject>();
        ArrayList<Node> nodeList = new ArrayList<Node>();
        Computer c = null;
        for (Node n : label.getNodes()) {
            c = n.toComputer();
            if (!c.isOnline() || !c.isIdle() || !(c instanceof SlaveComputer)) continue;
            nodeList.add(n);
            for (Executor e : c.getExecutors()) {
                if (!e.isIdle()) continue;
                String lockProjectName = "Lock-" + build.getProject().getName() + "-" + n.getDisplayName() + "-" + e.getDisplayName();
                Hudson hudson = Hudson.getInstance();
                for (Project p : hudson.getProjects()) {
                    if (!lockProjectName.equalsIgnoreCase(p.getName())) continue;
                    p.delete();
                }
                FreeStyleProject project = (FreeStyleProject)hudson.createProject(FreeStyleProject.class, lockProjectName);
                final String projectName = build.getProject().getName();
                project.getBuildersList().add((Object)new TestBuilder(){

                    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
                        boolean isParentProjectStillAlive = false;
                        try {
                            while (true) {
                                isParentProjectStillAlive = false;
                                for (Project project : Hudson.getInstance().getProjects()) {
                                    listener.getLogger().println("project: " + project.getName());
                                    if (!projectName.equalsIgnoreCase(project.getName()) || !project.isBuilding()) continue;
                                    isParentProjectStillAlive = true;
                                }
                                if (!isParentProjectStillAlive) {
                                    build.getProject().delete();
                                    return true;
                                }
                                listener.getLogger().println("zije parent: " + isParentProjectStillAlive);
                                Thread.sleep(1000L);
                            }
                        }
                        catch (InterruptedException ex) {
                            build.getProject().delete();
                            return true;
                        }
                    }
                });
                project.setAssignedNode(n);
                java.util.concurrent.Future f = project.scheduleBuild2(0);
                lockBuildList.add(f);
                fspList.add(project);
            }
        }
        return new LockingTasks(lockBuildList, fspList, nodeList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean perform(AbstractBuild build, Launcher launcher, final BuildListener listener) {
        try {
            Label label = build.getProject().getAssignedLabel();
            if (label == null) {
                throw new Exception("Set label in the \"Tie this project to a node\" section + in the project configaration.");
            }
            if (build.getBuiltOn().toComputer() instanceof Hudson.MasterComputer) {
                throw new Exception("Distributed testing task cannot be perform on master. Please change the label.");
            }
            if (this.testDir == null || "".equals(this.testDir)) {
                throw new Exception("Directory with tests must be set.");
            }
            if (label.getNodes().size() < 2) {
                throw new Exception("Number of nodes in label " + label + " must be more than one. Distributed Testing was cancelled.");
            }
            if (this.isWaitForNodes()) {
                this.waitForNodes(build, listener);
            }
            LockingTasks lockingTasks = this.lockExecutors(label, build);
            this.copyLibraries(build.getWorkspace().child("lib"));
            listener.getLogger().println("finished");
            if (this.isCompileTests()) {
                listener.getLogger().print("Compiling sources on slave " + build.getBuiltOnStr() + " :");
                this.compileTests(build);
                listener.getLogger().println("finished");
            }
            String directoryWithCompiledTests = null;
            directoryWithCompiledTests = this.compileTests ? "tests" : this.getTestDir();
            if ("\\".equals(this.getFileSeparatorForNode(build.getBuiltOn()))) {
                directoryWithCompiledTests = directoryWithCompiledTests.replace("/", "\\");
            }
            final LinkedList<String> tests = this.findTestsInProjectWorkspace(build.getWorkspace().child(directoryWithCompiledTests));
            listener.getLogger().println();
            listener.getLogger().println("Print all tests files:");
            Iterator it = tests.iterator();
            while (it.hasNext()) {
                listener.getLogger().println((String)it.next());
            }
            listener.getLogger().println();
            build.getWorkspace().child("results").mkdirs();
            final ArrayList<String> listOfNodes = new ArrayList<String>();
            for (Node n : lockingTasks.getNodeList()) {
                listOfNodes.add(n.getDisplayName());
            }
            if (build.getBuiltOn().toComputer() instanceof SlaveComputer) {
                listOfNodes.add(build.getBuiltOnStr());
            }
            listener.getLogger().println();
            listener.getLogger().println("Lists all test nodes:");
            for (String node : listOfNodes) {
                listener.getLogger().println(node);
            }
            listener.getLogger().println();
            final String projectName = build.getProject().getName();
            listener.getLogger().println("Call build-on slave to run tests");
            build.getWorkspace().act((FilePath.FileCallable)new FilePath.FileCallable<Boolean>(){

                public Boolean invoke(File f, VirtualChannel channel) throws IOException, InterruptedException {
                    TreeMap<String, Future> mapNodeFuture = new TreeMap<String, Future>();
                    for (String n : listOfNodes) {
                        mapNodeFuture.put(n, null);
                    }
                    Future future = null;
                    listener.getLogger().println("Start sending tests");
                    long startTime = System.currentTimeMillis();
                    while (!tests.isEmpty()) {
                        Iterator i$ = mapNodeFuture.keySet().iterator();
                        while (i$.hasNext()) {
                            String n;
                            final String nodeName = n = (String)i$.next();
                            future = (Future)mapNodeFuture.get(n);
                            if (future == null) {
                                final String testClass = (String)tests.poll();
                                if (testClass != null) {
                                    future = channel.callAsync((Callable)new Callable<Boolean, Throwable>(){

                                        public Boolean call() throws Throwable {
                                            AbstractBuild build = null;
                                            for (Project p : Hudson.getInstance().getProjects()) {
                                                if (!(p instanceof FreeStyleProject) || !projectName.equals(p.getName())) continue;
                                                FreeStyleProject f = (FreeStyleProject)p;
                                                build = (AbstractBuild)f.getLastBuild();
                                            }
                                            Node node = Hudson.getInstance().getNode(nodeName);
                                            String workspaceOnTestNode = DistTestingBuilder.this.getWorkspaceForThisProjectOnNode(node, build);
                                            Boolean b = (Boolean)new FilePath(node.getChannel(), workspaceOnTestNode).act((FilePath.FileCallable)new FilePath.FileCallable<Boolean>(){

                                                /*
                                                 * WARNING - Removed try catching itself - possible behaviour change.
                                                 */
                                                public Boolean invoke(File file, VirtualChannel channel) throws IOException, InterruptedException {
                                                    listener.getLogger().println("Run test " + testClass + " on node: " + nodeName);
                                                    org.apache.tools.ant.Project project = null;
                                                    try {
                                                        File baseDir = file;
                                                        File resultsDir = new File(baseDir, "results");
                                                        project = new org.apache.tools.ant.Project();
                                                        project.init();
                                                        project.setBaseDir(baseDir);
                                                        JUnitTest test = new JUnitTest(testClass, true, true, false);
                                                        test.setTodir(resultsDir);
                                                        FormatterElement fe = new FormatterElement();
                                                        FormatterElement.TypeAttribute ta = new FormatterElement.TypeAttribute();
                                                        ta.setValue("xml");
                                                        fe.setType(ta);
                                                        test.addFormatter(fe);
                                                        JUnitTask junit = null;
                                                        try {
                                                            junit = new JUnitTask();
                                                        }
                                                        catch (Exception ex) {
                                                            ex.printStackTrace(listener.getLogger());
                                                        }
                                                        junit.addTest(test);
                                                        junit.setProject(project);
                                                        junit.init();
                                                        Path p = junit.createClasspath();
                                                        p.add(Path.systemClasspath);
                                                        File fileTest = null;
                                                        fileTest = DistTestingBuilder.this.compileTests ? new File(baseDir, "tests") : new File(baseDir, DistTestingBuilder.this.getTestDir());
                                                        File libDirFile = new File(baseDir, "lib");
                                                        p.createPathElement().setLocation(libDirFile);
                                                        for (File l : libDirFile.listFiles()) {
                                                            if (!l.isFile()) continue;
                                                            p.createPathElement().setLocation(l);
                                                        }
                                                        p.createPathElement().setLocation(fileTest);
                                                        File distsDirFile = null;
                                                        for (DistLocations distLoc : DistTestingBuilder.this.getDistLocations()) {
                                                            distsDirFile = new File(baseDir, distLoc.getDistDir());
                                                            p.createPathElement().setLocation(new File(baseDir, distLoc.getDistDir()));
                                                            if (!distsDirFile.isDirectory()) continue;
                                                            for (File f : distsDirFile.listFiles()) {
                                                                if (f.isDirectory()) continue;
                                                                p.createPathElement().setLocation(f);
                                                            }
                                                        }
                                                        File libDirFile2 = null;
                                                        for (LibLocations libLoc : DistTestingBuilder.this.getLibLocations()) {
                                                            libDirFile2 = new File(baseDir, libLoc.getLibDir());
                                                            p.createPathElement().setLocation(libDirFile2);
                                                            if (!libDirFile2.isDirectory()) continue;
                                                            for (File f2 : libDirFile2.listFiles()) {
                                                                if (f2.isDirectory()) continue;
                                                                p.createPathElement().setLocation(f2);
                                                            }
                                                        }
                                                        Target target = new Target();
                                                        target.setName("test");
                                                        target.addTask((Task)junit);
                                                        project.addTarget("test", target);
                                                        project.executeTarget("test");
                                                    }
                                                    finally {
                                                        project = null;
                                                        System.gc();
                                                    }
                                                    return true;
                                                }
                                            });
                                            return true;
                                        }
                                    });
                                    mapNodeFuture.put(n, future);
                                }
                            } else {
                                try {
                                    if (((Boolean)future.get(100L, TimeUnit.MILLISECONDS)).booleanValue()) {
                                        mapNodeFuture.put(n, null);
                                    }
                                }
                                catch (ExecutionException ex) {
                                    ex.printStackTrace(listener.getLogger());
                                }
                                catch (TimeoutException ex) {
                                    // empty catch block
                                }
                            }
                            future = null;
                        }
                    }
                    listener.getLogger().println("Waiting for last tests results");
                    for (String n : mapNodeFuture.keySet()) {
                        future = (Future)mapNodeFuture.get(n);
                        if (future == null) continue;
                        try {
                            future.get();
                        }
                        catch (ExecutionException ex) {
                            Logger.getLogger(DistTestingBuilder.class.getName()).log(Level.SEVERE, null, ex);
                        }
                    }
                    long time = System.currentTimeMillis() - startTime;
                    listener.getLogger().println("Testing time: " + time);
                    return true;
                }
            });
        }
        catch (Throwable ex) {
            ex.printStackTrace(listener.getLogger());
        }
        return true;
    }

    public String getWorkspaceForThisProjectOnNode(Node node, AbstractBuild build) throws IOException, Exception {
        String path = null;
        if (node != null && node.toComputer().isOnline()) {
            path = node.getRootPath().getRemote() + this.getFileSeparatorForNode(node) + "workspace" + this.getFileSeparatorForNode(node) + build.getProject().getName();
        }
        return path;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    private FilePath getFilePathOnMasterForClass(String className) throws ClassNotFoundException, URISyntaxException {
        FilePath f = null;
        Class<?> cls = this.getClass().getClassLoader().loadClass(className);
        ProtectionDomain pDomain = cls.getProtectionDomain();
        CodeSource cSource = pDomain.getCodeSource();
        URL url = cSource.getLocation();
        f = new FilePath(new File(url.toURI()));
        return f;
    }

    public boolean isWaitForNodes() {
        return this.waitForNodes;
    }

    private void copyLibraries(FilePath toWhere) throws IOException, InterruptedException, Exception {
        if (!toWhere.exists()) {
            toWhere.mkdirs();
        }
        FilePath junit = this.getFilePathOnMasterForClass("org.junit.runner.JUnitCore");
        FilePath antJunit = this.getFilePathOnMasterForClass("org.apache.tools.ant.taskdefs.optional.junit.JUnitTask");
        FilePath ant = this.getFilePathOnMasterForClass("org.apache.tools.ant.Project");
        junit.copyTo(toWhere.child(junit.getName()));
        antJunit.copyTo(toWhere.child(antJunit.getName()));
        ant.copyTo(toWhere.child(ant.getName()));
    }

    private LinkedList<String> findTestsInProjectWorkspace(FilePath dirWithTest) throws IOException, Exception {
        TestFilePathVisitor filePathVisitor = new TestFilePathVisitor();
        FilePathDirScanner filePathDirScanner = new FilePathDirScanner();
        filePathDirScanner.scan(dirWithTest, filePathVisitor);
        if (filePathVisitor.getListOfTests().size() <= 0) {
            throw new Exception("Could not find any test classes in the directory: " + dirWithTest);
        }
        return filePathVisitor.getListOfTests();
    }

    public String getTestDir() {
        return this.testDir;
    }

    private void compileTests(AbstractBuild build) throws IOException, InterruptedException {
        build.getWorkspace().act((FilePath.FileCallable)new FilePath.FileCallable<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Boolean invoke(File f, VirtualChannel channel) {
                org.apache.tools.ant.Project project = null;
                try {
                    File testsDir = null;
                    testsDir = new File(f, "tests");
                    if (!testsDir.exists()) {
                        testsDir.mkdir();
                    }
                    project = new org.apache.tools.ant.Project();
                    project.setBaseDir(f);
                    Target compTestTarget = new Target();
                    compTestTarget.setName("compile-tests");
                    Javac javacTask = new Javac();
                    javacTask.setClasspath(Path.systemClasspath);
                    Path libs = javacTask.createClasspath();
                    File libDirFile = new File(f, "lib");
                    libs.createPathElement().setLocation(libDirFile);
                    for (File file : libDirFile.listFiles()) {
                        if (!file.isFile()) continue;
                        libs.createPathElement().setLocation(file);
                    }
                    libDirFile = null;
                    for (Serializable serializable : DistTestingBuilder.this.getLibLocations()) {
                        libDirFile = new File(f, ((LibLocations)serializable).getLibDir());
                        libs.createPathElement().setLocation(new File(f, ((LibLocations)serializable).getLibDir()));
                        if (!libDirFile.isDirectory()) continue;
                        for (File file : libDirFile.listFiles()) {
                            if (!file.isFile()) continue;
                            libs.createPathElement().setLocation(new File(f, ((LibLocations)serializable).getLibDir() + "/" + file.getName()));
                        }
                    }
                    Path dists = javacTask.createClasspath();
                    File distsDirFile = null;
                    for (DistLocations distLoc : DistTestingBuilder.this.getDistLocations()) {
                        distsDirFile = new File(f, distLoc.getDistDir());
                        dists.createPathElement().setLocation(new File(f, distLoc.getDistDir()));
                        if (!distsDirFile.isDirectory()) continue;
                        for (File file : distsDirFile.listFiles()) {
                            if (!file.isFile()) continue;
                            dists.createPathElement().setLocation(new File(f, distLoc.getDistDir() + file.getName()));
                        }
                    }
                    Path srcPath = new Path(project);
                    srcPath.setLocation(new File(f, DistTestingBuilder.this.testDir));
                    javacTask.setSrcdir(srcPath);
                    javacTask.setDestdir(testsDir);
                    javacTask.setProject(project);
                    compTestTarget.addTask((Task)javacTask);
                    project.addTarget("compile-tests", compTestTarget);
                    project.executeTarget("compile-tests");
                }
                finally {
                    project = null;
                    System.gc();
                }
                return true;
            }
        });
    }

    public boolean isCompileTests() {
        return this.compileTests;
    }

    private String getFileSeparatorForNode(Node node) throws IOException, Exception {
        return (String)node.getChannel().call((Callable)new Callable<String, Exception>(){

            public String call() throws Exception {
                return System.getProperty("file.separator");
            }
        });
    }

    public DistLocations[] getDistLocations() {
        return this.distLocations;
    }

    public LibLocations[] getLibLocations() {
        return this.libLocations;
    }

    private void waitForNodes(AbstractBuild build, BuildListener listener) throws InterruptedException {
        Label label = build.getProject().getAssignedLabel();
        Set nodes = label.getNodes();
        while (true) {
            boolean allFree = true;
            for (Node n : nodes) {
                if (!n.toComputer().isOnline() || n.toComputer().isIdle() || build.getBuiltOnStr().equalsIgnoreCase(n.getNodeName())) continue;
                allFree = false;
            }
            if (allFree) {
                listener.getLogger().println("All nodes are free now.");
                return;
            }
            listener.getLogger().println("Waiting for all other nodes in label " + label);
            Thread.sleep(1000L);
        }
    }

    @ExportedBean
    public static final class LibLocations
    implements Serializable {
        @Exported
        public final String libDir;

        @DataBoundConstructor
        public LibLocations(String libDir) {
            this.libDir = libDir;
        }

        public String getLibDir() {
            return this.libDir;
        }
    }

    @ExportedBean
    public static final class DistLocations
    implements Serializable {
        @Exported
        public final String distDir;

        @DataBoundConstructor
        public DistLocations(String distDir) {
            this.distDir = distDir;
        }

        public String getDistDir() {
            return this.distDir;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        public FormValidation doCheckDistDir(@QueryParameter String value) throws IOException, ServletException, InterruptedException {
            if (value.length() == 0) {
                return FormValidation.warning((String)"If you don't set the distribution path then tests will search for the compiled classes in the standard classpath of the slave");
            }
            return FormValidation.ok();
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public String getDisplayName() {
            return "Distibuted Testing";
        }

        public boolean configure(StaplerRequest req, JSONObject o) throws Descriptor.FormException {
            this.save();
            return super.configure(req, o);
        }
    }
}

